/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import java.util.List;

class TextTracestateAppender {
    private static final TextTracestateAppender INSTANCE = new TextTracestateAppender();
    private final ThreadLocal<StringBuilder> tracestateBuffer = new ThreadLocal();

    static TextTracestateAppender instance() {
        return INSTANCE;
    }

    TextTracestateAppender() {
    }

    public String join(List<String> tracestate, int tracestateSizeLimit) {
        StringBuilder buffer = this.getTracestateBuffer();
        int size = tracestate.size();
        for (int i = 0; i < size; ++i) {
            this.appendTracestateHeaderValue(tracestate.get(i), buffer, tracestateSizeLimit);
        }
        return buffer.toString();
    }

    void appendTracestateHeaderValue(String headerValue, StringBuilder tracestateBuffer, int tracestateSizeLimit) {
        int endIndex = headerValue.length();
        if (tracestateBuffer.length() + endIndex + 1 > tracestateSizeLimit) {
            endIndex = 0;
            for (int i = headerValue.length() - 1; i >= 0; --i) {
                if (headerValue.charAt(i) != ',' || tracestateBuffer.length() + i >= tracestateSizeLimit) continue;
                endIndex = i;
                break;
            }
        }
        if (endIndex > 0) {
            if (tracestateBuffer.length() > 0) {
                tracestateBuffer.append(',');
            }
            tracestateBuffer.append(headerValue, 0, endIndex);
        }
    }

    private StringBuilder getTracestateBuffer() {
        StringBuilder buffer = this.tracestateBuffer.get();
        if (buffer == null) {
            buffer = new StringBuilder();
            this.tracestateBuffer.set(buffer);
        } else {
            buffer.setLength(0);
        }
        return buffer;
    }
}

