/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.jms.JmsMessagePropertyAccessor;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Enumeration;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class JmsInstrumentationHelperImpl
implements JmsInstrumentationHelper<Destination, javax.jms.Message, MessageListener> {
    static final String TIBCO_TMP_QUEUE_PREFIX = "$TMP$";
    static final String TEMP = "<temporary>";
    static final String FRAMEWORK_NAME = "JMS";
    private static final Logger logger = LoggerFactory.getLogger(JmsInstrumentationHelperImpl.class);
    private final ElasticApmTracer tracer;
    private final CoreConfiguration coreConfiguration;
    private final MessagingConfiguration messagingConfiguration;

    public JmsInstrumentationHelperImpl(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.messagingConfiguration = tracer.getConfig(MessagingConfiguration.class);
    }

    @Override
    @Nullable
    public Span startJmsSendSpan(Destination destination, javax.jms.Message message) {
        AbstractSpan<?> activeSpan = this.tracer.getActive();
        if (activeSpan == null) {
            return null;
        }
        boolean isDestinationNameComputed = false;
        String destinationName = this.extractDestinationName(null, destination);
        if (this.isTempDestination(destination, destinationName)) {
            destinationName = TEMP;
            isDestinationNameComputed = true;
        }
        if (this.ignoreDestination(destinationName)) {
            return null;
        }
        Span span = activeSpan.createExitSpan();
        if (span == null) {
            return null;
        }
        span.withType("messaging").withSubtype("jms").withAction("send").activate();
        try {
            span.propagateTraceContext(message, JmsMessagePropertyAccessor.instance());
            if (span.isSampled()) {
                span.getContext().getDestination().getService().withName("jms").withResource("jms").withType("messaging");
                if (destinationName != null) {
                    span.getContext().getDestination().getService().getResource().append("/").append(destinationName);
                    span.withName("JMS SEND to ");
                    this.addDestinationDetails(null, destination, destinationName, (AbstractSpan)span);
                    if (isDestinationNameComputed) {
                        message.setStringProperty("elastic_apm_dest_name", destinationName);
                    }
                }
            }
        }
        catch (JMSException e) {
            logger.error("Failed to capture JMS span", e);
        }
        return span;
    }

    @Override
    @Nullable
    public Transaction startJmsTransaction(javax.jms.Message parentMessage, Class<?> instrumentedClass) {
        Transaction transaction = this.tracer.startChildTransaction(parentMessage, JmsMessagePropertyAccessor.instance(), instrumentedClass.getClassLoader());
        if (transaction != null) {
            transaction.setFrameworkName(FRAMEWORK_NAME);
        }
        return transaction;
    }

    @Override
    public void makeChildOf(Transaction childTransaction, javax.jms.Message parentMessage) {
        TraceContext.getFromTraceContextTextHeaders().asChildOf(childTransaction.getTraceContext(), parentMessage, JmsMessagePropertyAccessor.instance());
    }

    @Override
    @Nullable
    public MessageListener wrapLambda(@Nullable MessageListener listener) {
        if (listener != null && listener.getClass().getName().contains("/")) {
            return new MessageListenerWrapper(listener);
        }
        return listener;
    }

    @Override
    @Nullable
    public String extractDestinationName(@Nullable javax.jms.Message message, Destination destination) {
        String destinationName = null;
        if (message != null) {
            try {
                destinationName = message.getStringProperty("elastic_apm_dest_name");
            }
            catch (JMSException e) {
                logger.warn("Failed to get destination name from message property", e);
            }
        }
        if (destinationName == null) {
            try {
                if (destination instanceof Queue) {
                    destinationName = ((Queue)destination).getQueueName();
                } else if (destination instanceof Topic) {
                    destinationName = ((Topic)destination).getTopicName();
                }
            }
            catch (JMSException e) {
                logger.error("Failed to obtain destination name", e);
            }
        }
        return destinationName;
    }

    private boolean isTempDestination(Destination destination, @Nullable String extractedDestinationName) {
        return destination instanceof TemporaryQueue || destination instanceof TemporaryTopic || extractedDestinationName != null && extractedDestinationName.startsWith(TIBCO_TMP_QUEUE_PREFIX);
    }

    @Override
    public boolean ignoreDestination(@Nullable String destinationName) {
        return WildcardMatcher.isAnyMatch(this.messagingConfiguration.getIgnoreMessageQueues(), destinationName);
    }

    @Override
    public void addDestinationDetails(@Nullable javax.jms.Message message, Destination destination, String destinationName, AbstractSpan span) {
        if (destination instanceof Queue) {
            ((AbstractSpan)((AbstractSpan)span.appendToName("queue ")).appendToName(destinationName)).getContext().getMessage().withQueue(destinationName);
        } else if (destination instanceof Topic) {
            ((AbstractSpan)((AbstractSpan)span.appendToName("topic ")).appendToName(destinationName)).getContext().getMessage().withQueue(destinationName);
        }
    }

    @Override
    public void setMessageAge(javax.jms.Message message, AbstractSpan span) {
        try {
            long messageTimestamp = message.getJMSTimestamp();
            if (messageTimestamp > 0L) {
                long now = System.currentTimeMillis();
                if (now > messageTimestamp) {
                    span.getContext().getMessage().withAge(now - messageTimestamp);
                } else {
                    span.getContext().getMessage().withAge(0L);
                }
            }
        }
        catch (JMSException e) {
            logger.warn("Failed to get message timestamp", e);
        }
    }

    @Override
    public void addMessageDetails(@Nullable javax.jms.Message message, AbstractSpan span) {
        if (message == null) {
            return;
        }
        try {
            Message messageContext = span.getContext().getMessage();
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && message instanceof TextMessage) {
                messageContext.withBody(((TextMessage)message).getText());
            }
            if (this.coreConfiguration.isCaptureHeaders()) {
                messageContext.addHeader("JMSMessageID", message.getJMSMessageID());
                messageContext.addHeader("JMSExpiration", String.valueOf(message.getJMSExpiration()));
                messageContext.addHeader("JMSTimestamp", String.valueOf(message.getJMSTimestamp()));
                Enumeration properties = message.getPropertyNames();
                while (properties.hasMoreElements()) {
                    String propertyName = String.valueOf(properties.nextElement());
                    if (propertyName.equals("elastic_apm_dest_name") || propertyName.equals(JMS_TRACE_PARENT_PROPERTY) || WildcardMatcher.anyMatch(this.coreConfiguration.getSanitizeFieldNames(), propertyName) != null) continue;
                    messageContext.addHeader(propertyName, String.valueOf(message.getObjectProperty(propertyName)));
                }
            }
        }
        catch (JMSException e) {
            logger.warn("Failed to retrieve message details", e);
        }
    }

    public static class MessageListenerWrapper
    implements MessageListener {
        private final MessageListener delegate;

        MessageListenerWrapper(MessageListener delegate) {
            this.delegate = delegate;
        }

        public void onMessage(javax.jms.Message message) {
            this.delegate.onMessage(message);
        }
    }
}

