/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.impl.transaction.AbstractHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jms.JMSException;
import javax.jms.Message;

public class JmsMessagePropertyAccessor
extends AbstractHeaderGetter<String, Message>
implements TextHeaderGetter<Message>,
TextHeaderSetter<Message> {
    private static final Logger logger = LoggerFactory.getLogger(JmsMessagePropertyAccessor.class);
    private static final JmsMessagePropertyAccessor INSTANCE = new JmsMessagePropertyAccessor();

    public static JmsMessagePropertyAccessor instance() {
        return INSTANCE;
    }

    private JmsMessagePropertyAccessor() {
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Message message) {
        headerName = this.jmsifyHeaderName(headerName);
        String value = null;
        try {
            value = message.getStringProperty(headerName);
        }
        catch (JMSException e) {
            logger.error("Failed to extract JMS message property", e);
        }
        return value;
    }

    @Nonnull
    private String jmsifyHeaderName(String headerName) {
        if (headerName.equals("elastic-apm-traceparent")) {
            headerName = JmsInstrumentationHelper.JMS_TRACE_PARENT_PROPERTY;
        }
        return headerName;
    }

    @Override
    public void setHeader(String headerName, String headerValue, Message message) {
        headerName = this.jmsifyHeaderName(headerName);
        try {
            message.setStringProperty(headerName, headerValue);
        }
        catch (JMSException e) {
            logger.warn("Failed to set JMS message property. Distributed tracing cannot work without that.");
            logger.debug("Detailed error: ", e);
        }
    }
}

