/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.kafka.BaseKafkaInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;

public class KafkaConsumerInstrumentation
extends BaseKafkaInstrumentation {
    public KafkaConsumerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.apache.kafka.clients.consumer.KafkaConsumer");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("poll").and(ElementMatchers.isPublic());
    }

    @Override
    public Class<?> getAdviceClass() {
        return KafkaConsumerAdvice.class;
    }

    public static class KafkaConsumerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        @Nullable
        public static Span pollStart() {
            Transaction transaction;
            if (ElasticApmInstrumentation.tracer == null) {
                return null;
            }
            AbstractSpan<?> activeSpan = ElasticApmInstrumentation.tracer.getActive();
            if (activeSpan == null) {
                return null;
            }
            if (BaseKafkaInstrumentation.messagingConfiguration.shouldEndMessagingTransactionOnPoll() && activeSpan instanceof Transaction && "messaging".equals((transaction = (Transaction)activeSpan).getType())) {
                ((Transaction)transaction.deactivate()).end();
                return null;
            }
            Span span = activeSpan.createExitSpan();
            if (span == null) {
                return null;
            }
            span.withType("messaging").withSubtype("kafka").withAction("poll").withName("KafkaConsumer#poll", 100);
            span.getContext().getDestination().getService().withType("messaging").withName("kafka").withResource("kafka");
            span.activate();
            return span;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void pollEnd(@Advice.Enter @Nullable Span span, @Advice.Thrown Throwable throwable) {
            if (span != null) {
                span.captureException(throwable);
                ((Span)span.deactivate()).end();
            }
        }
    }
}

