/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log.shipper;

import co.elastic.apm.agent.log.shipper.FileChangeListener;
import co.elastic.apm.agent.log.shipper.TailableFile;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;

public class FileTailer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FileTailer.class);
    private final List<TailableFile> tailableFiles = new CopyOnWriteArrayList<TailableFile>();
    private final FileChangeListener fileChangeListener;
    private final ByteBuffer buffer;
    private final int maxLinesPerCycle;
    private volatile boolean stopRequested = false;
    private final long idleTimeMs;
    private final Thread processingThread;

    public FileTailer(FileChangeListener fileChangeListener, int bufferSize, int maxLinesPerCycle, long idleTimeMs, ThreadFactory processingThreadFactory) {
        this.fileChangeListener = fileChangeListener;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.maxLinesPerCycle = maxLinesPerCycle;
        this.idleTimeMs = idleTimeMs;
        this.processingThread = processingThreadFactory.newThread(this);
    }

    public TailableFile tailFile(File file) throws IOException {
        TailableFile tailableFile = new TailableFile(file);
        this.tailableFiles.add(tailableFile);
        return tailableFile;
    }

    public void start() {
        this.processingThread.start();
    }

    public void stop(long timeout) throws Exception {
        this.stopRequested = true;
        this.fileChangeListener.onShutdownInitiated();
        this.processingThread.join(timeout);
    }

    @Override
    public void run() {
        try {
            while (!this.stopRequested) {
                int readLines = this.pollAll();
                if (readLines != 0) continue;
                this.fileChangeListener.onIdle();
                Thread.sleep(this.idleTimeMs);
            }
            this.pollAll();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        this.fileChangeListener.onShutdownComplete();
    }

    private int pollAll() {
        int lines = 0;
        for (TailableFile tailableFile : this.tailableFiles) {
            try {
                lines += tailableFile.tail(this.buffer, this.fileChangeListener, this.maxLinesPerCycle);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return lines;
    }
}

