/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logging;

import co.elastic.apm.agent.configuration.converter.ByteValue;
import co.elastic.apm.agent.configuration.converter.ByteValueConverter;
import co.elastic.apm.agent.logging.Log4j2ConfigurationFactory;
import co.elastic.apm.agent.logging.LogFormat;
import co.elastic.apm.agent.logging.LogLevel;
import co.elastic.apm.agent.shaded.apache.logging.log4j.Level;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.Configurator;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource;
import java.util.List;
import javax.annotation.Nullable;

public class LoggingConfiguration
extends ConfigurationOptionProvider {
    public static final String SYSTEM_OUT = "System.out";
    static final String LOG_LEVEL_KEY = "log_level";
    static final String LOG_FILE_KEY = "log_file";
    static final String LOG_FILE_SIZE_KEY = "log_file_size";
    static final String DEFAULT_LOG_FILE = "System.out";
    private static final String LOGGING_CATEGORY = "Logging";
    public static final String AGENT_HOME_PLACEHOLDER = "_AGENT_HOME_";
    static final String DEPRECATED_LOG_LEVEL_KEY = "logging.log_level";
    static final String DEPRECATED_LOG_FILE_KEY = "logging.log_file";
    static final String DEFAULT_MAX_SIZE = "50mb";
    static final String SHIP_AGENT_LOGS = "ship_agent_logs";
    static final String LOG_FORMAT_SOUT_KEY = "log_format_sout";
    public static final String LOG_FORMAT_FILE_KEY = "log_format_file";
    public ConfigurationOption<LogLevel> logLevel = ConfigurationOption.enumOption(LogLevel.class).key("log_level").aliasKeys("logging.log_level").configurationCategory("Logging").description("Sets the logging level for the agent.\n\nThis option is case-insensitive.").dynamic(true).addChangeListener(new ConfigurationOption.ChangeListener<LogLevel>(){

        @Override
        public void onChange(ConfigurationOption<?> configurationOption, LogLevel oldValue, LogLevel newValue) {
            LoggingConfiguration.setLogLevel(newValue);
        }
    }).buildWithDefault(LogLevel.INFO);
    public ConfigurationOption<String> logFile = ConfigurationOption.stringOption().key("log_file").aliasKeys("logging.log_file").configurationCategory("Logging").description("Sets the path of the agent logs.\nThe special value `_AGENT_HOME_` is a placeholder for the folder the elastic-apm-agent.jar is in.\nExample: `_AGENT_HOME_/logs/elastic-apm.log`\n\nWhen set to the special value 'System.out',\nthe logs are sent to standard out.\n\nNOTE: When logging to a file,\nthe log will be formatted in new-line-delimited JSON.\nWhen logging to std out, the log will be formatted as plain-text.").dynamic(false).buildWithDefault("System.out");
    private final ConfigurationOption<Boolean> logCorrelationEnabled = ConfigurationOption.booleanOption().key("enable_log_correlation").configurationCategory("Logging").description("A boolean specifying if the agent should integrate into SLF4J's https://www.slf4j.org/api/org/slf4j/MDC.html[MDC] to enable trace-log correlation.\nIf set to `true`, the agent will set the `trace.id` and `transaction.id` for the currently active spans and transactions to the MDC.\nSince version 1.16.0, the agent also adds `error.id` of captured error to the MDC just before the error message is logged.\nSee <<log-correlation>> for more details.\n\nNOTE: While it's allowed to enable this setting at runtime, you can't disable it without a restart.").dynamic(true).addValidator(new ConfigurationOption.Validator<Boolean>(){

        @Override
        public void assertValid(Boolean value) {
            if (LoggingConfiguration.this.logCorrelationEnabled != null && LoggingConfiguration.this.isLogCorrelationEnabled() && Boolean.FALSE.equals(value)) {
                throw new IllegalArgumentException("Disabling the log correlation at runtime is not possible.");
            }
        }
    }).buildWithDefault(false);
    public ConfigurationOption<ByteValue> logFileMaxSize = ByteValueConverter.byteOption().key("log_file_size").configurationCategory("Logging").description("The size of the log file.\n\nThe agent always keeps one history file so that the max total log file size is twice the value of this setting.\n").dynamic(false).tags("added[1.17.0]").buildWithDefault(ByteValue.of("50mb"));
    private final ConfigurationOption<Boolean> shipAgentLogs = ConfigurationOption.booleanOption().key("ship_agent_logs").configurationCategory("Logging").description("This helps you to centralize your agent logs by automatically sending them to APM Server (requires APM Server 7.9+).\nUse the Kibana Logs App to see the logs from all of your agents.\n\nIf <<config-log-file,`log_file`>> is set to a real file location (as opposed to `System.out`),\nthis file will be shipped to the APM Server by the agent.\nNote that <<config-log-format-file,`log_format_file`>> needs to be set to `JSON` when this option is enabled.\n\nIf APM Server is temporarily not available, the agent will resume sending where it left off as soon as the server is back up again.\nThe amount of logs that can be buffered is at least <<config-log-file-size,`log_file_size`>>.\nIf the application crashes or APM Server is not available when shutting down,\nthe agent will resume shipping the log file when the application restarts.\n\nResume on restart does not work when the log is inside an ephemeral container.\nConsider mounting the log file to the host or use Filebeat if you need the extra reliability in this case.\n\nIf <<config-log-file,`log_file`>> is set to `System.out`,\nthe agent will additionally log into a temp file which is then sent to APM Server.\nThis log's size is determined by <<config-log-file-size,`log_file_size`>> and will be deleted on shutdown.\nThis means that logs that could not be sent before the application terminates are lost.").dynamic(false).tags("added[not officially added yet]", "internal").buildWithDefault(false);
    public ConfigurationOption<LogFormat> logFormatSout = ConfigurationOption.enumOption(LogFormat.class).key("log_format_sout").configurationCategory("Logging").description("Defines the log format when logging to `System.out`.\n\nWhen set to `JSON`, the agent will format the logs in an https://github.com/elastic/ecs-logging-java[ECS-compliant JSON format]\nwhere each log event is serialized as a single line.").tags("added[1.17.0]").buildWithDefault(LogFormat.PLAIN_TEXT);
    public ConfigurationOption<LogFormat> logFormatFile = ConfigurationOption.enumOption(LogFormat.class).key("log_format_file").configurationCategory("Logging").description("Defines the log format when logging to a file.\n\nWhen set to `JSON`, the agent will format the logs in an https://github.com/elastic/ecs-logging-java[ECS-compliant JSON format]\nwhere each log event is serialized as a single line.\n").tags("added[1.17.0]").buildWithDefault(LogFormat.PLAIN_TEXT);

    public static void init(List<ConfigurationSource> sources, String ephemeralId) {
        Configurator.initialize(new Log4j2ConfigurationFactory(sources, ephemeralId).getConfiguration());
    }

    public String getLogFile() {
        return this.logFile.get();
    }

    private static void setLogLevel(@Nullable LogLevel level) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        Configurator.setRootLevel(Level.toLevel(level.toString(), Level.INFO));
    }

    public boolean isLogCorrelationEnabled() {
        return this.logCorrelationEnabled.get();
    }

    public boolean isShipAgentLogs() {
        return this.shipAgentLogs.get();
    }

    public LogFormat getLogFormatFile() {
        return this.logFormatFile.get();
    }
}

