/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class Timer
implements Recyclable {
    private static final double MS_IN_MICROS = TimeUnit.MILLISECONDS.toMicros(1L);
    private AtomicLong totalTime = new AtomicLong();
    private AtomicLong count = new AtomicLong();

    public void update(long durationUs) {
        this.update(durationUs, 1L);
    }

    public void update(long durationUs, long count) {
        this.totalTime.addAndGet(durationUs);
        this.count.addAndGet(count);
    }

    public long getTotalTimeUs() {
        return this.totalTime.get();
    }

    public double getTotalTimeMs() {
        return (double)this.totalTime.get() / MS_IN_MICROS;
    }

    public long getCount() {
        return this.count.get();
    }

    public boolean hasContent() {
        return this.count.get() > 0L;
    }

    @Override
    public void resetState() {
        this.totalTime.set(0L);
        this.count.set(0L);
    }
}

