/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mule4;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.mule.runtime.module.artifact.api.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;

public class Mule4OverrideClassLoaderLookupInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("ClassLoaderLookupPolicy");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getPackageLookupStrategy").and(ElementMatchers.takesArgument(0, String.class));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("mule");
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return true;
    }

    @Override
    public Class<?> getAdviceClass() {
        return Mule4OverrideClassLoaderLookupAdvice.class;
    }

    public static class Mule4OverrideClassLoaderLookupAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void makeParentOnlyForAgentClasses(@Advice.Argument(value=0) @Nullable String packageName, @Advice.Return(readOnly=false) LookupStrategy lookupStrategy) {
            if (packageName != null && packageName.startsWith("co.elastic.apm.agent") && Mule4OverrideClassLoaderLookupInstrumentation.class.getClassLoader() == null) {
                lookupStrategy = new DelegateOnlyLookupStrategy(ClassLoader.getSystemClassLoader());
            }
        }
    }
}

