/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.okhttp;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.okhttp.AbstractOkHttp3ClientInstrumentation;
import co.elastic.apm.agent.okhttp.OkHttpClientHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp3ClientInstrumentation
extends AbstractOkHttp3ClientInstrumentation {
    public OkHttp3ClientInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public Class<?> getAdviceClass() {
        return OkHttpClient3ExecuteAdvice.class;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("okhttp3.RealCall");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.returns(ElementMatchers.named("okhttp3.Response")));
    }

    public static class OkHttpClient3ExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.FieldValue(value="originalRequest", typing=Assigner.Typing.DYNAMIC, readOnly=false) @Nullable Object originalRequest, @Advice.Local(value="span") Span span) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            if (originalRequest == null) {
                return;
            }
            AbstractSpan<?> parent = ElasticApmInstrumentation.tracer.getActive();
            if (originalRequest instanceof Request) {
                Request request = (Request)originalRequest;
                HttpUrl url = request.url();
                span = HttpClientHelper.startHttpClientSpan(parent, request.method(), url.toString(), url.scheme(), OkHttpClientHelper.computeHostName(url.host()), url.port());
                if (span != null) {
                    TextHeaderSetter<Request.Builder> headerSetter;
                    span.activate();
                    if (AbstractOkHttp3ClientInstrumentation.headerSetterHelperManager != null && (headerSetter = AbstractOkHttp3ClientInstrumentation.headerSetterHelperManager.getForClassLoaderOfClass(Request.class)) != null) {
                        Request.Builder builder = ((Request)originalRequest).newBuilder();
                        span.propagateTraceContext(builder, headerSetter);
                        originalRequest = builder.build();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Return @Nullable Response response, @Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                try {
                    if (response != null) {
                        int statusCode = response.code();
                        span.getContext().getHttp().withStatusCode(statusCode);
                    }
                    span.captureException(t);
                }
                finally {
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }
}

