/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracing.impl;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.sampling.ConstantSampler;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.opentracing.impl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.opentracing.impl.OpenTracingTextMapBridge;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Map;
import javax.annotation.Nullable;

public class ApmSpanBuilderInstrumentation
extends OpenTracingBridgeInstrumentation {
    private static final String FRAMEWORK_NAME = "OpenTracing";
    private static final Logger logger = LoggerFactory.getLogger(ApmSpanBuilderInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ApmSpanBuilderInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmSpanBuilder");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class CreateSpanInstrumentation
    extends ApmSpanBuilderInstrumentation {
        public CreateSpanInstrumentation() {
            super(ElementMatchers.named("createSpan"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void createSpan(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) @Nullable AbstractSpan<?> parentContext, @Advice.Origin Class<?> spanBuilderClass, @Advice.FieldValue(value="tags") Map<String, Object> tags, @Advice.FieldValue(value="operationName") String operationName, @Advice.FieldValue(value="microseconds") long microseconds, @Advice.Argument(value=1) @Nullable Iterable<Map.Entry<String, String>> baggage, @Advice.Return(readOnly=false) Object span) {
            span = CreateSpanInstrumentation.doCreateTransactionOrSpan(parentContext, tags, operationName, microseconds, baggage, spanBuilderClass.getClassLoader());
        }

        @Nullable
        public static AbstractSpan<?> doCreateTransactionOrSpan(@Nullable AbstractSpan<?> parentContext, Map<String, Object> tags, String operationName, long microseconds, @Nullable Iterable<Map.Entry<String, String>> baggage, ClassLoader applicationClassLoader) {
            Span result = null;
            if (tracer != null) {
                result = parentContext == null ? CreateSpanInstrumentation.createTransaction(tags, operationName, microseconds, baggage, tracer, applicationClassLoader) : (microseconds >= 0L ? tracer.startSpan(TraceContext.fromParent(), parentContext, microseconds) : tracer.startSpan(TraceContext.fromParent(), parentContext));
            }
            if (result != null) {
                ((AbstractSpan)result).incrementReferences();
            }
            return result;
        }

        @Nullable
        private static AbstractSpan<?> createTransaction(Map<String, Object> tags, String operationName, long microseconds, @Nullable Iterable<Map.Entry<String, String>> baggage, ElasticApmTracer tracer, ClassLoader classLoader) {
            if ("client".equals(tags.get("span.kind"))) {
                logger.info("Ignoring transaction '{}', as a span.kind client can never be a transaction. Consider creating a span for the whole request.", (Object)operationName);
                return tracer.noopTransaction();
            }
            Object samplingPriority = tags.get("sampling.priority");
            Sampler sampler = samplingPriority instanceof Number ? ConstantSampler.of(((Number)samplingPriority).intValue() > 0) : tracer.getSampler();
            Transaction transaction = tracer.startChildTransaction(baggage, OpenTracingTextMapBridge.instance(), sampler, microseconds, classLoader);
            if (transaction != null) {
                transaction.setFrameworkName(ApmSpanBuilderInstrumentation.FRAMEWORK_NAME);
            }
            return transaction;
        }
    }
}

