/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.plugin.api.ApiInstrumentation;
import co.elastic.apm.agent.plugin.api.HeaderInjectorBridge;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;

public class AbstractSpanInstrumentation
extends ApiInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public AbstractSpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.AbstractSpanImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class InjectTraceHeadersInstrumentation
    extends AbstractSpanInstrumentation {
        public InjectTraceHeadersInstrumentation() {
            super(ElementMatchers.named("doInjectTraceHeaders"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void injectTraceHeaders(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) MethodHandle addHeaderMethodHandle, @Advice.Argument(value=1) @Nullable Object headerInjector) throws Throwable {
            if (headerInjector != null) {
                context.propagateTraceContext(headerInjector, HeaderInjectorBridge.get(addHeaderMethodHandle));
            }
        }
    }

    public static class IsSampledInstrumentation
    extends AbstractSpanInstrumentation {
        public IsSampledInstrumentation() {
            super(ElementMatchers.named("isSampled"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void isSampled(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Return(readOnly=false) boolean sampled) {
            sampled = context.isSampled();
        }
    }

    public static class ActivateInstrumentation
    extends AbstractSpanInstrumentation {
        public ActivateInstrumentation() {
            super(ElementMatchers.named("activate"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void activate(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context) {
            context.activate();
        }
    }

    public static class AddBooleanLabelInstrumentation
    extends AbstractSpanInstrumentation {
        public AddBooleanLabelInstrumentation() {
            super(ElementMatchers.named("doAddBooleanLabel"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void addLabel(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) String key, @Nullable @Advice.Argument(value=1) Boolean value) {
            if (value != null) {
                context.addLabel(key, value);
            }
        }
    }

    public static class AddNumberLabelInstrumentation
    extends AbstractSpanInstrumentation {
        public AddNumberLabelInstrumentation() {
            super(ElementMatchers.named("doAddNumberLabel"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void addLabel(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) String key, @Nullable @Advice.Argument(value=1) Number value) {
            if (value != null) {
                context.addLabel(key, value);
            }
        }
    }

    public static class AddStringLabelInstrumentation
    extends AbstractSpanInstrumentation {
        public AddStringLabelInstrumentation() {
            super(ElementMatchers.named("doAddTag").or(ElementMatchers.named("doAddStringLabel")));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void addLabel(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) String key, @Nullable @Advice.Argument(value=1) String value) {
            if (value != null) {
                context.addLabel(key, value);
            }
        }
    }

    public static class GetTraceIdInstrumentation
    extends AbstractSpanInstrumentation {
        public GetTraceIdInstrumentation() {
            super(ElementMatchers.named("getTraceId").and(ElementMatchers.takesArguments(0)));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void getTraceId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Return(readOnly=false) String traceId) {
            traceId = context.getTraceContext().getTraceId().toString();
        }
    }

    public static class GetIdInstrumentation
    extends AbstractSpanInstrumentation {
        public GetIdInstrumentation() {
            super(ElementMatchers.named("getId").and(ElementMatchers.takesArguments(0)));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void getId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Return(readOnly=false) String id) {
            id = context.getTraceContext().getId().toString();
        }
    }

    public static class LegacyCaptureExceptionInstrumentation
    extends AbstractSpanInstrumentation {
        public LegacyCaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class)).and(ElementMatchers.returns(Void.class)));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void captureException(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) Throwable t) {
            context.captureException(t);
        }
    }

    public static class CaptureExceptionInstrumentation
    extends AbstractSpanInstrumentation {
        public CaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class)).and(ElementMatchers.returns(String.class)));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void captureException(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) Throwable t, @Advice.Return(readOnly=false) String errorId) {
            errorId = context.captureExceptionAndGetErrorId(t);
        }
    }

    public static class EndWithTimestampInstrumentation
    extends AbstractSpanInstrumentation {
        public EndWithTimestampInstrumentation() {
            super(ElementMatchers.named("end").and(ElementMatchers.takesArguments(Long.TYPE)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void end(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) long epochMicros) {
            context.end(epochMicros);
        }
    }

    public static class EndInstrumentation
    extends AbstractSpanInstrumentation {
        public EndInstrumentation() {
            super(ElementMatchers.named("end").and(ElementMatchers.takesArguments(0)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void end(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context) {
            context.end();
        }
    }

    public static class SetStartTimestampInstrumentation
    extends AbstractSpanInstrumentation {
        public SetStartTimestampInstrumentation() {
            super(ElementMatchers.named("doSetStartTimestamp").and(ElementMatchers.takesArguments(Long.TYPE)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void setStartTimestamp(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) long epochMicros) {
            context.setStartTimestamp(epochMicros);
        }
    }

    public static class DoCreateSpanInstrumentation
    extends AbstractSpanInstrumentation {
        public DoCreateSpanInstrumentation() {
            super(ElementMatchers.named("doCreateSpan"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void doCreateSpan(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Return(readOnly=false) Object result) {
            result = context.createSpan();
        }
    }

    public static class SetTypesInstrumentation
    extends AbstractSpanInstrumentation {
        public SetTypesInstrumentation() {
            super(ElementMatchers.named("doSetTypes"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void setType(@Advice.Argument(value=0) Object span, @Advice.Argument(value=1) @Nullable String type, @Advice.Argument(value=2) @Nullable String subtype, @Advice.Argument(value=3) @Nullable String action) {
            if (span instanceof Span) {
                ((Span)span).setType(type, subtype, action);
            }
        }
    }

    public static class SetTypeInstrumentation
    extends AbstractSpanInstrumentation {
        public SetTypeInstrumentation() {
            super(ElementMatchers.named("doSetType"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void setType(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) String type) {
            if (context instanceof Transaction) {
                ((Transaction)context).withType(type);
            } else if (context instanceof Span) {
                ((Span)context).setType(type, null, null);
            }
        }
    }

    public static class SetNameInstrumentation
    extends AbstractSpanInstrumentation {
        public SetNameInstrumentation() {
            super(ElementMatchers.named("doSetName"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void setName(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> context, @Advice.Argument(value=0) String name) {
            context.withName(name, 1000);
        }
    }
}

