/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class CaptureSpanInstrumentation
extends ElasticApmInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(CaptureSpanInstrumentation.class);
    private final StacktraceConfiguration config;

    public CaptureSpanInstrumentation(ElasticApmTracer tracer) {
        this.config = tracer.getConfig(StacktraceConfiguration.class);
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onMethodEnter(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="value") String spanName, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="type") String type, @Nullable @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="subtype") String subtype, @Nullable @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.CaptureSpan", method="action") String action, @Advice.Local(value="span") Span span) {
        if (tracer != null) {
            AbstractSpan<?> parent = tracer.getActive();
            if (parent != null) {
                span = parent.createSpan();
                span.setType(type, subtype, action);
                ((Span)span.withName(spanName.isEmpty() ? signature : spanName)).activate();
            } else {
                logger.debug("Not creating span for {} because there is no currently active span.", (Object)signature);
            }
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onMethodExit(@Nullable @Advice.Local(value="span") Span span, @Advice.Thrown Throwable t) {
        if (span != null) {
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("co.elastic.apm.api.CaptureSpan");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.config.getApplicationPackages(), ElementMatchers.none()).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.CaptureSpan"));
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return false;
    }

    @Override
    public final Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("public-api", "annotations");
    }
}

