/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.impl.transaction.AbstractHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;

public class HeaderExtractorBridge
extends AbstractHeaderGetter<String, Object>
implements TextHeaderGetter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(HeaderExtractorBridge.class);
    @Nullable
    private static HeaderExtractorBridge INSTANCE;
    private final MethodHandle getFirstHeaderMethod;

    private HeaderExtractorBridge(MethodHandle getFirstHeaderMethod) {
        this.getFirstHeaderMethod = getFirstHeaderMethod;
    }

    public static HeaderExtractorBridge get(MethodHandle getFirstHeaderMethod) {
        if (INSTANCE == null) {
            INSTANCE = new HeaderExtractorBridge(getFirstHeaderMethod);
        }
        return INSTANCE;
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Object carrier) {
        String value = null;
        try {
            value = this.getFirstHeaderMethod.invoke(carrier, headerName);
        }
        catch (Throwable throwable) {
            logger.error("Failed to extract trace context headers", throwable);
        }
        return value;
    }
}

