/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.plugin.api.ApiInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;

@Deprecated
public class LegacySpanInstrumentation
extends ApiInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public LegacySpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.SpanImpl").and(ElementMatchers.not(ElementMatchers.hasSuperType(ElementMatchers.named("co.elastic.apm.api.AbstractSpanImpl"))));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class IsSampledInstrumentation
    extends LegacySpanInstrumentation {
        public IsSampledInstrumentation() {
            super(ElementMatchers.named("isSampled"));
        }

        @Advice.OnMethodExit
        public static void addTag(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Return(readOnly=false) boolean sampled) {
            sampled = span.isSampled();
        }
    }

    public static class ActivateInstrumentation
    extends LegacySpanInstrumentation {
        public ActivateInstrumentation() {
            super(ElementMatchers.named("activate"));
        }

        @Advice.OnMethodEnter
        public static void addTag(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span) {
            span.activate();
        }
    }

    public static class AddTagInstrumentation
    extends LegacySpanInstrumentation {
        public AddTagInstrumentation() {
            super(ElementMatchers.named("addTag"));
        }

        @Advice.OnMethodEnter
        public static void addTag(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) String value) {
            span.addLabel(key, value);
        }
    }

    public static class GetTraceIdInstrumentation
    extends LegacySpanInstrumentation {
        public GetTraceIdInstrumentation() {
            super(ElementMatchers.named("getTraceId").and(ElementMatchers.takesArguments(0)));
        }

        @Advice.OnMethodExit
        public static void getTraceId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Return(readOnly=false) String traceId) {
            if (tracer != null) {
                traceId = span.getTraceContext().getTraceId().toString();
            }
        }
    }

    public static class GetIdInstrumentation
    extends LegacySpanInstrumentation {
        public GetIdInstrumentation() {
            super(ElementMatchers.named("getId").and(ElementMatchers.takesArguments(0)));
        }

        @Advice.OnMethodExit
        public static void getId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Return(readOnly=false) String id) {
            if (tracer != null) {
                id = span.getTraceContext().getId().toString();
            }
        }
    }

    public static class CaptureExceptionInstrumentation
    extends LegacySpanInstrumentation {
        public CaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class)));
        }

        @Advice.OnMethodExit
        public static void doCreateSpan(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Argument(value=0) Throwable t) {
            span.captureException(t);
        }
    }

    public static class EndInstrumentation
    extends LegacySpanInstrumentation {
        public EndInstrumentation() {
            super(ElementMatchers.named("end"));
        }

        @Advice.OnMethodEnter
        public static void end(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span) {
            span.end();
        }
    }

    public static class DoCreateSpanInstrumentation
    extends LegacySpanInstrumentation {
        public DoCreateSpanInstrumentation() {
            super(ElementMatchers.named("doCreateSpan"));
        }

        @Advice.OnMethodExit
        public static void doCreateSpan(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Return(readOnly=false) Object result) {
            result = span.createSpan();
        }
    }

    public static class SetTypeInstrumentation
    extends LegacySpanInstrumentation {
        public SetTypeInstrumentation() {
            super(ElementMatchers.named("setType"));
        }

        @Advice.OnMethodEnter
        public static void setType(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Argument(value=0) String type) {
            if (span instanceof Span) {
                ((Span)span).setType(type, null, null);
            }
        }
    }

    public static class SetNameInstrumentation
    extends LegacySpanInstrumentation {
        public SetNameInstrumentation() {
            super(ElementMatchers.named("setName"));
        }

        @Advice.OnMethodEnter
        public static void setName(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) AbstractSpan<?> span, @Advice.Argument(value=0) String name) {
            span.withName(name, 1000);
        }
    }
}

