/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;

public class CommonsExecAsyncInstrumentation
extends ElasticApmInstrumentation {
    private static final String DEFAULT_EXECUTOR_CLASS = "org.apache.commons.exec.DefaultExecutor";
    private static final String DAEMON_EXECUTOR_CLASS = "org.apache.commons.exec.DaemonExecutor";

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Executor");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named(DEFAULT_EXECUTOR_CLASS).or(ElementMatchers.named(DAEMON_EXECUTOR_CLASS)).or(ElementMatchers.hasSuperClass(ElementMatchers.named(DEFAULT_EXECUTOR_CLASS)));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("createThread").and(ElementMatchers.takesArgument(0, Runnable.class));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("apache-commons-exec", "process");
    }

    @Override
    public Class<?> getAdviceClass() {
        return CommonsExecAdvice.class;
    }

    public static final class CommonsExecAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.Argument(value=0, readOnly=false) Runnable runnable) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            runnable = ElasticApmInstrumentation.tracer.getActive().withActive(runnable);
        }
    }
}

