/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.process.BaseProcessInstrumentation;
import co.elastic.apm.agent.process.ProcessHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;

public abstract class ProcessExitInstrumentation
extends BaseProcessInstrumentation {
    @Override
    public final ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("java.lang.ProcessImpl").or(ElementMatchers.named("java.lang.UNIXProcess"));
    }

    public static class Destroy
    extends ProcessExitInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isPublic().and(ElementMatchers.named("destroy").or(ElementMatchers.named("destroyForcibly")));
        }

        @Override
        public Class<?> getAdviceClass() {
            return DestroyAdvice.class;
        }

        public static class DestroyAdvice {
            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
            private static void onExit(@Advice.This Process process) {
                if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                    return;
                }
                ProcessHelper.endProcess(process, false);
            }
        }
    }

    public static class WaitFor
    extends ProcessExitInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("waitFor");
        }

        @Override
        public Class<?> getAdviceClass() {
            return WaitForAdvice.class;
        }

        public static class WaitForAdvice {
            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
            private static void onExit(@Advice.This Process process) {
                if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                    return;
                }
                ProcessHelper.endProcess(process, true);
            }
        }
    }
}

