/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler;

import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.profiler.FixedNanoClock;
import co.elastic.apm.agent.profiler.NanoClock;
import co.elastic.apm.agent.profiler.ProfilingActivationListener;
import co.elastic.apm.agent.profiler.SamplingProfiler;
import co.elastic.apm.agent.profiler.SystemNanoClock;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.io.File;
import java.io.IOException;

public class ProfilingFactory
extends AbstractLifecycleListener {
    private final SamplingProfiler profiler;
    private final NanoClock nanoClock;
    private final File activationEventsFile;
    private final File jfrFile;

    public ProfilingFactory(ElasticApmTracer tracer) throws IOException {
        boolean envTest = false;
        if (!$assertionsDisabled) {
            envTest = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.nanoClock = envTest ? new FixedNanoClock() : new SystemNanoClock();
        this.activationEventsFile = File.createTempFile("apm-activation-events-", ".bin");
        this.jfrFile = File.createTempFile("apm-traces-", ".jfr");
        this.profiler = new SamplingProfiler(tracer, ExecutorUtils.createSingleThreadSchedulingDeamonPool("sampling-profiler"), this.nanoClock, this.activationEventsFile, this.jfrFile);
    }

    @Override
    public void start(ElasticApmTracer tracer) {
        this.profiler.start(tracer);
        tracer.registerSpanListener(new ProfilingActivationListener(tracer, this.profiler));
    }

    @Override
    public void stop() throws Exception {
        this.profiler.stop();
        if (!this.jfrFile.delete()) {
            this.jfrFile.deleteOnExit();
        }
        if (!this.activationEventsFile.delete()) {
            this.activationEventsFile.deleteOnExit();
        }
    }

    public SamplingProfiler getProfiler() {
        return this.profiler;
    }

    public NanoClock getNanoClock() {
        return this.nanoClock;
    }
}

