/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.quartz.job;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.quartz.job.JobTransactionNameAdvice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;

public class JobTransactionNameInstrumentation
extends ElasticApmInstrumentation {
    public static final String TRANSACTION_TYPE = "scheduled";
    public static final String INSTRUMENTATION_TYPE = "quartz";
    private final Collection<String> applicationPackages;

    public JobTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.none()).or(ElementMatchers.nameStartsWith("org.quartz.job")).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.quartz.Job"))).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").or(ElementMatchers.named("executeInternal")).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.quartz.JobExecutionContext").and(ElementMatchers.isInterface())));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList(INSTRUMENTATION_TYPE);
    }

    @Override
    public Class<?> getAdviceClass() {
        return JobTransactionNameAdvice.class;
    }
}

