/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis.jedis;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;

public class JedisSpanNameInstrumentation
extends ElasticApmInstrumentation {
    @Advice.OnMethodEnter
    private static void setSpanNameToRedisProtocolCommand(@Advice.Argument(value=1) Object command) {
        Span activeSpan;
        AbstractSpan<?> active;
        if (tracer != null && (active = tracer.getActive()) instanceof Span && "redis".equals((activeSpan = (Span)active).getSubtype())) {
            activeSpan.withName(command.toString());
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("redis.clients.jedis.Protocol");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("sendCommand").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, ElementMatchers.nameEndsWith("RedisOutputStream"))).and(ElementMatchers.takesArgument(1, ElementMatchers.nameEndsWith("Command"))).and(ElementMatchers.takesArgument(2, byte[][].class));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "jedis");
    }
}

