/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis.lettuce;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.lettuce.Lettuce5StartSpanInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import io.lettuce.core.protocol.RedisCommand;
import java.util.Arrays;
import java.util.Collection;

public abstract class Lettuce5StopSpanInstrumentation
extends ElasticApmInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(Lettuce5StopSpanInstrumentation.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.lettuce").and(ElementMatchers.nameContains("Command"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.lettuce.core.protocol.RedisCommand"));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "lettuce");
    }

    public static class OnCancel
    extends Lettuce5StopSpanInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void beforeComplete(@Advice.This RedisCommand command) {
            Span span;
            if (!command.isDone() && !command.isCancelled() && (span = Lettuce5StartSpanInstrumentation.commandToSpan.remove(command)) != null) {
                logger.debug("Command#cancel");
                span.end();
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("cancel").and(ElementMatchers.takesArguments(0));
        }
    }

    public static class OnCompleteExceptionally
    extends Lettuce5StopSpanInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void beforeComplete(@Advice.This RedisCommand command, @Advice.Argument(value=0) Throwable throwable) {
            Span span;
            if (!command.isDone() && !command.isCancelled() && (span = Lettuce5StartSpanInstrumentation.commandToSpan.remove(command)) != null) {
                logger.debug("Command#completeExceptionally");
                ((Span)span.captureException(throwable)).end();
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("completeExceptionally").and(ElementMatchers.takesArguments(Throwable.class));
        }
    }

    public static class OnComplete
    extends Lettuce5StopSpanInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void beforeComplete(@Advice.This RedisCommand command) {
            Span span;
            if (!command.isDone() && !command.isCancelled() && (span = Lettuce5StartSpanInstrumentation.commandToSpan.remove(command)) != null) {
                logger.debug("Command#complete");
                span.end();
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("complete").and(ElementMatchers.takesArguments(0));
        }
    }
}

