/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.impl.MetaData;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.HttpUtils;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nullable;

public class AbstractIntakeApiHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final int GZIP_COMPRESSION_LEVEL = 1;
    private static final Object WAIT_LOCK = new Object();
    protected final ReporterConfiguration reporterConfiguration;
    protected final PayloadSerializer payloadSerializer;
    protected final ApmServerClient apmServerClient;
    protected final byte[] metaData;
    protected Deflater deflater;
    protected long currentlyTransmitting = 0L;
    protected long reported = 0L;
    protected long dropped = 0L;
    @Nullable
    protected HttpURLConnection connection;
    @Nullable
    protected OutputStream os;
    protected int errorCount;
    protected volatile boolean shutDown;

    public AbstractIntakeApiHandler(ReporterConfiguration reporterConfiguration, MetaData metaData, PayloadSerializer payloadSerializer, ApmServerClient apmServerClient) {
        this.reporterConfiguration = reporterConfiguration;
        this.payloadSerializer = payloadSerializer;
        this.apmServerClient = apmServerClient;
        this.deflater = new Deflater(1);
        payloadSerializer.serializeMetaDataNdJson(metaData);
        this.metaData = payloadSerializer.toString().getBytes(StandardCharsets.UTF_8);
        try {
            payloadSerializer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static long getRandomJitter(long backoffTimeMillis) {
        long tenPercentOfBackoffTimeMillis = (long)((double)backoffTimeMillis * 0.1);
        return (long)((double)(tenPercentOfBackoffTimeMillis * 2L) * Math.random()) - tenPercentOfBackoffTimeMillis;
    }

    static long getBackoffTimeSeconds(long errorCount) {
        return (long)Math.pow(Math.min(errorCount, 6L), 2.0);
    }

    protected boolean shouldEndRequest() {
        boolean endRequest;
        long written = this.deflater.getBytesWritten() + 16384L;
        boolean bl = endRequest = written >= this.reporterConfiguration.getApiRequestSize();
        if (endRequest && this.logger.isDebugEnabled()) {
            this.logger.debug("Flushing, because request size limit exceeded {}/{}", (Object)written, (Object)this.reporterConfiguration.getApiRequestSize());
        }
        return endRequest;
    }

    protected HttpURLConnection startRequest(String endpoint) throws IOException {
        HttpURLConnection connection = this.apmServerClient.startRequest(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Starting new request to {}", (Object)connection.getURL());
        }
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setChunkedStreamingMode(16384);
        connection.setRequestProperty("Content-Encoding", "deflate");
        connection.setRequestProperty("Content-Type", "application/x-ndjson");
        connection.setUseCaches(false);
        connection.connect();
        this.os = new DeflaterOutputStream(connection.getOutputStream(), this.deflater);
        this.os.write(this.metaData);
        return connection;
    }

    public void endRequest() {
        if (this.connection != null) {
            try {
                this.payloadSerializer.flush();
                if (this.os != null) {
                    this.os.close();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Flushing {} uncompressed {} compressed bytes", (Object)this.deflater.getBytesRead(), (Object)this.deflater.getBytesWritten());
                }
                InputStream inputStream = this.connection.getInputStream();
                int responseCode = this.connection.getResponseCode();
                if (responseCode >= 400) {
                    this.onRequestError(responseCode, inputStream, null);
                } else {
                    this.onRequestSuccess();
                }
            }
            catch (IOException e) {
                try {
                    this.onRequestError(this.connection.getResponseCode(), this.connection.getErrorStream(), e);
                }
                catch (IOException e1) {
                    this.onRequestError(-1, this.connection.getErrorStream(), e);
                }
            }
            finally {
                HttpUtils.consumeAndClose(this.connection);
                this.connection = null;
                this.deflater.reset();
                this.currentlyTransmitting = 0L;
            }
        }
    }

    protected void onRequestError(Integer responseCode, InputStream inputStream, @Nullable IOException e) {
        this.onConnectionError(responseCode, this.currentlyTransmitting, 0L);
        if (e != null) {
            this.logger.error("Error sending data to APM server: {}, response code is {}", (Object)e.getMessage(), (Object)responseCode);
            this.logger.debug("Sending payload to APM server failed", e);
        }
        if (this.logger.isWarnEnabled()) {
            try {
                this.logger.warn(IOUtils.toString(inputStream));
            }
            catch (IOException e1) {
                this.logger.warn(e1.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectionError(@Nullable Integer responseCode, long droppedEvents, long reportedEvents) {
        this.dropped += droppedEvents;
        this.reported += reportedEvents;
        if (responseCode == null || responseCode > 429) {
            this.apmServerClient.onConnectionError();
        } else if (responseCode == 404) {
            this.logger.warn("It seems like you are using a version of the APM Server which is not compatible with this agent. Please use APM Server 6.5.0 or newer.");
        }
        long backoffTimeSeconds = AbstractIntakeApiHandler.getBackoffTimeSeconds(this.errorCount++);
        this.logger.info("Backing off for {} seconds (+/-10%)", (Object)backoffTimeSeconds);
        long backoffTimeMillis = TimeUnit.SECONDS.toMillis(backoffTimeSeconds);
        if (backoffTimeMillis > 0L) {
            try {
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.wait(backoffTimeMillis + AbstractIntakeApiHandler.getRandomJitter(backoffTimeMillis));
                }
            }
            catch (InterruptedException e) {
                this.logger.info("APM Agent ReportingEventHandler had been interrupted", e);
            }
        }
    }

    public long getReported() {
        return this.reported;
    }

    public long getDropped() {
        return this.dropped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.shutDown = true;
        Object object = WAIT_LOCK;
        synchronized (object) {
            WAIT_LOCK.notifyAll();
        }
    }

    protected void onRequestSuccess() {
        this.errorCount = 0;
        this.reported += this.currentlyTransmitting;
    }
}

