/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.impl.MetaData;
import co.elastic.apm.agent.report.AbstractIntakeApiHandler;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.ApmServerReporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReportingEvent;
import co.elastic.apm.agent.report.ReportingEventHandler;
import co.elastic.apm.agent.report.processor.ProcessorEventHandler;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.util.ThreadUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public class IntakeV2ReportingEventHandler
extends AbstractIntakeApiHandler
implements ReportingEventHandler {
    public static final String INTAKE_V2_URL = "/intake/v2/events";
    private final ProcessorEventHandler processorEventHandler;
    private final Timer timeoutTimer;
    @Nullable
    private ApmServerReporter reporter;
    @Nullable
    private TimerTask timeoutTask;

    public IntakeV2ReportingEventHandler(ReporterConfiguration reporterConfiguration, ProcessorEventHandler processorEventHandler, PayloadSerializer payloadSerializer, MetaData metaData, ApmServerClient apmServerClient) {
        super(reporterConfiguration, metaData, payloadSerializer, apmServerClient);
        this.processorEventHandler = processorEventHandler;
        this.timeoutTimer = new Timer(ThreadUtils.addElasticApmThreadPrefix("request-timeout-timer"), true);
    }

    @Override
    public void init(ApmServerReporter reporter) {
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ReportingEvent event, long sequence, boolean endOfBatch) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Receiving {} event (sequence {})", (Object)event.getType(), (Object)sequence);
        }
        try {
            if (!this.shutDown) {
                this.handleEvent(event, sequence, endOfBatch);
            }
        }
        finally {
            event.resetState();
        }
    }

    private void handleEvent(ReportingEvent event, long sequence, boolean endOfBatch) {
        if (event.getType() == null) {
            return;
        }
        if (event.getType() == ReportingEvent.ReportingEventType.FLUSH) {
            this.endRequest();
            return;
        }
        if (event.getType() == ReportingEvent.ReportingEventType.SHUTDOWN) {
            this.shutDown = true;
            this.endRequest();
            return;
        }
        this.processorEventHandler.onEvent(event, sequence, endOfBatch);
        try {
            if (this.connection == null) {
                this.connection = this.startRequest(INTAKE_V2_URL);
            }
            this.writeEvent(event);
        }
        catch (Exception e) {
            this.logger.error("Failed to handle event of type {} with this error: {}", (Object)event.getType(), (Object)e.getMessage());
            this.logger.debug("Event handling failure", e);
            this.endRequest();
            this.onConnectionError(null, this.currentlyTransmitting + 1L, 0L);
        }
        if (this.shouldEndRequest()) {
            this.endRequest();
        }
    }

    int getBufferSize() {
        return this.payloadSerializer.getBufferSize();
    }

    private void writeEvent(ReportingEvent event) {
        if (event.getTransaction() != null) {
            ++this.currentlyTransmitting;
            this.payloadSerializer.serializeTransactionNdJson(event.getTransaction());
            event.getTransaction().decrementReferences();
        } else if (event.getSpan() != null) {
            ++this.currentlyTransmitting;
            this.payloadSerializer.serializeSpanNdJson(event.getSpan());
            event.getSpan().decrementReferences();
        } else if (event.getError() != null) {
            ++this.currentlyTransmitting;
            this.payloadSerializer.serializeErrorNdJson(event.getError());
            event.getError().recycle();
        } else if (event.getMetricRegistry() != null) {
            this.payloadSerializer.serializeMetrics(event.getMetricRegistry());
        }
    }

    private void cancelTimeout() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
            this.timeoutTask = null;
        }
    }

    @Override
    protected HttpURLConnection startRequest(String endpoint) throws IOException {
        HttpURLConnection connection = super.startRequest(endpoint);
        if (this.os != null) {
            this.payloadSerializer.setOutputStream(this.os);
        }
        if (this.reporter != null) {
            this.timeoutTask = new FlushOnTimeoutTimerTask(this.reporter);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Scheduling request timeout in {}", (Object)this.reporterConfiguration.getApiRequestTime());
            }
            this.timeoutTimer.schedule(this.timeoutTask, this.reporterConfiguration.getApiRequestTime().getMillis());
        }
        return connection;
    }

    @Override
    public void endRequest() {
        this.cancelTimeout();
        super.endRequest();
    }

    @Override
    public void close() {
        super.close();
        this.logger.info("Reported events: {}", (Object)this.reported);
        this.logger.info("Dropped events: {}", (Object)this.dropped);
        this.timeoutTimer.cancel();
    }

    private static class FlushOnTimeoutTimerTask
    extends TimerTask {
        private static final Logger logger = LoggerFactory.getLogger(FlushOnTimeoutTimerTask.class);
        private final ApmServerReporter reporter;
        @Nullable
        private volatile Future<Void> flush;

        private FlushOnTimeoutTimerTask(ApmServerReporter reporter) {
            this.reporter = reporter;
        }

        @Override
        public void run() {
            logger.debug("Request flush because the request timeout occurred");
            try {
                this.flush = this.reporter.flush();
            }
            catch (Exception e) {
                logger.info("Failed to register a Flush event to the disruptor: {}", (Object)e.getMessage());
            }
        }

        @Override
        public boolean cancel() {
            boolean cancel = super.cancel();
            Future<Void> flush = this.flush;
            if (flush != null) {
                flush.cancel(false);
            }
            return cancel;
        }
    }
}

