/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public abstract class ServletVersionInstrumentation
extends ElasticApmInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(ServletVersionInstrumentation.class);
    public static volatile boolean alreadyLogged = false;

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Servlet").or(ElementMatchers.nameContainsIgnoreCase("jsp"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.servlet.Servlet")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("servlet-api");
    }

    public static class Service
    extends ServletVersionInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("service").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.ServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.ServletResponse")));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.This Servlet servlet) {
            ServletContext servletContext;
            if (alreadyLogged) {
                return;
            }
            alreadyLogged = true;
            ServletConfig servletConfig = servlet.getServletConfig();
            int majorVersion = -1;
            int minorVersion = -1;
            String serverInfo = null;
            if (servletConfig != null && null != (servletContext = servletConfig.getServletContext())) {
                majorVersion = servletContext.getMajorVersion();
                minorVersion = servletContext.getMinorVersion();
                serverInfo = servletContext.getServerInfo();
            }
            logger.info("Servlet container info = {}", (Object)serverInfo);
            if (majorVersion < 3) {
                logger.warn("Unsupported servlet version detected: {}.{}, no Servlet transaction will be created", (Object)majorVersion, (Object)minorVersion);
            }
        }
    }

    public static class Init
    extends ServletVersionInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("init").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.ServletConfig")));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.Argument(value=0) @Nullable ServletConfig servletConfig) {
            ServletContext servletContext;
            if (alreadyLogged) {
                return;
            }
            alreadyLogged = true;
            int majorVersion = -1;
            int minorVersion = -1;
            String serverInfo = null;
            if (servletConfig != null && null != (servletContext = servletConfig.getServletContext())) {
                majorVersion = servletContext.getMajorVersion();
                minorVersion = servletContext.getMinorVersion();
                serverInfo = servletContext.getServerInfo();
            }
            logger.info("Servlet container info = {}", (Object)serverInfo);
            if (majorVersion < 3) {
                logger.warn("Unsupported servlet version detected: {}.{}, no Servlet transaction will be created", (Object)majorVersion, (Object)minorVersion);
            }
        }
    }
}

