/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.servlet.AsyncInstrumentation;
import co.elastic.apm.agent.servlet.ServletApiAdvice;
import co.elastic.apm.agent.servlet.ServletTransactionHelper;
import co.elastic.apm.agent.servlet.helper.ApmAsyncListener;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.AtomicQueueFactory;
import co.elastic.apm.agent.shaded.jctools.queues.spec.ConcurrentQueueSpec;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;

public class AsyncContextAdviceHelperImpl
implements AsyncInstrumentation.AsyncContextAdviceHelper<AsyncContext> {
    private static final String ASYNC_LISTENER_ADDED = ServletApiAdvice.class.getName() + ".asyncListenerAdded";
    private static final int MAX_POOLED_ELEMENTS = 256;
    private final ObjectPool<ApmAsyncListener> asyncListenerObjectPool;
    private final ServletTransactionHelper servletTransactionHelper;
    private final ElasticApmTracer tracer;

    public AsyncContextAdviceHelperImpl(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.servletTransactionHelper = new ServletTransactionHelper(tracer);
        this.asyncListenerObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new ApmAsyncListenerAllocator());
    }

    ServletTransactionHelper getServletTransactionHelper() {
        return this.servletTransactionHelper;
    }

    @Override
    public void onExitStartAsync(AsyncContext asyncContext) {
        ServletRequest request = asyncContext.getRequest();
        if (request.getAttribute(ASYNC_LISTENER_ADDED) != null) {
            return;
        }
        Transaction transaction = this.tracer.currentTransaction();
        if (transaction != null && transaction.isSampled() && request.getAttribute(ASYNC_LISTENER_ADDED) == null) {
            request.setAttribute(ASYNC_LISTENER_ADDED, (Object)Boolean.TRUE);
            asyncContext.addListener((AsyncListener)this.asyncListenerObjectPool.createInstance().withTransaction(transaction), asyncContext.getRequest(), asyncContext.getResponse());
            request.setAttribute(ServletTransactionHelper.ASYNC_ATTRIBUTE, (Object)Boolean.TRUE);
            request.setAttribute(ServletTransactionHelper.TRANSACTION_ATTRIBUTE, (Object)transaction);
        }
    }

    void recycle(ApmAsyncListener apmAsyncListener) {
        this.asyncListenerObjectPool.recycle(apmAsyncListener);
    }

    private final class ApmAsyncListenerAllocator
    implements Allocator<ApmAsyncListener> {
        private ApmAsyncListenerAllocator() {
        }

        @Override
        public ApmAsyncListener createInstance() {
            return new ApmAsyncListener(AsyncContextAdviceHelperImpl.this);
        }
    }
}

