/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.helper;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.servlet.ServletInstrumentation;
import co.elastic.apm.agent.servlet.helper.ServletRequestHeaderGetter;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class ServletTransactionCreationHelperImpl
implements ServletInstrumentation.ServletTransactionCreationHelper<HttpServletRequest> {
    private static final Logger logger = LoggerFactory.getLogger(ServletTransactionCreationHelperImpl.class);
    private final ElasticApmTracer tracer;
    private final CoreConfiguration coreConfiguration;
    private final WebConfiguration webConfiguration;

    public ServletTransactionCreationHelperImpl(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.webConfiguration = tracer.getConfig(WebConfiguration.class);
    }

    @Override
    @Nullable
    public Transaction createAndActivateTransaction(HttpServletRequest request) {
        Transaction transaction = null;
        if (this.tracer.currentTransaction() == null && !this.isExcluded(request.getServletPath(), request.getPathInfo(), request.getHeader("User-Agent")) && (transaction = this.tracer.startChildTransaction(request, ServletRequestHeaderGetter.getInstance(), request.getServletContext().getClassLoader())) != null) {
            transaction.activate();
        }
        return transaction;
    }

    private boolean isExcluded(String servletPath, @Nullable String pathInfo, @Nullable String userAgentHeader) {
        boolean isExcluded;
        WildcardMatcher excludeAgentMatcher;
        WildcardMatcher excludeUrlMatcher = WildcardMatcher.anyMatch(this.webConfiguration.getIgnoreUrls(), servletPath, pathInfo);
        if (excludeUrlMatcher != null && logger.isDebugEnabled()) {
            logger.debug("Not tracing this request as the URL {}{} is ignored by the matcher {}", servletPath, Objects.toString(pathInfo, ""), excludeUrlMatcher);
        }
        WildcardMatcher wildcardMatcher = excludeAgentMatcher = userAgentHeader != null ? WildcardMatcher.anyMatch(this.webConfiguration.getIgnoreUserAgents(), userAgentHeader) : null;
        if (excludeAgentMatcher != null) {
            logger.debug("Not tracing this request as the User-Agent {} is ignored by the matcher {}", (Object)userAgentHeader, (Object)excludeAgentMatcher);
        }
        boolean bl = isExcluded = excludeUrlMatcher != null || excludeAgentMatcher != null;
        if (!isExcluded && logger.isTraceEnabled()) {
            logger.trace("No matcher found for excluding this request with servlet-path: {}, path-info: {} and User-Agent: {}", servletPath, pathInfo, userAgentHeader);
        }
        return isExcluded;
    }
}

