/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.jctools.maps;

import co.elastic.apm.agent.shaded.jctools.maps.ConcurrentAutoTable;
import co.elastic.apm.agent.shaded.jctools.util.RangeUtil;
import co.elastic.apm.agent.shaded.jctools.util.UnsafeAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public class NonBlockingSetInt
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final long _nbsi_offset = UnsafeAccess.fieldOffset(NonBlockingSetInt.class, "_nbsi");
    private transient NBSI _nbsi = new NBSI(63, new ConcurrentAutoTable(), this);

    private final boolean CAS_nbsi(NBSI old, NBSI nnn) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, _nbsi_offset, old, nnn);
    }

    @Override
    public boolean add(Integer i) {
        return this.add((int)i);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Integer && this.remove((Integer)o);
    }

    @Override
    public boolean add(int i) {
        RangeUtil.checkPositiveOrZero(i, "i");
        return this._nbsi.add(i);
    }

    public boolean contains(int i) {
        return i >= 0 && this._nbsi.contains(i);
    }

    public boolean remove(int i) {
        return i >= 0 && this._nbsi.remove(i);
    }

    @Override
    public int size() {
        return this._nbsi.size();
    }

    public int length() {
        return this._nbsi._bits.length << 6;
    }

    @Override
    public void clear() {
        NBSI cleared = new NBSI(63, new ConcurrentAutoTable(), this);
        while (!this.CAS_nbsi(this._nbsi, cleared)) {
        }
    }

    public void print() {
        this._nbsi.print(0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new iter();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        NBSI nbsi = this._nbsi;
        int len = this._nbsi._bits.length << 6;
        s.writeInt(len);
        for (int i = 0; i < len; ++i) {
            s.writeBoolean(this._nbsi.contains(i));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int len = s.readInt();
        this._nbsi = new NBSI(len, new ConcurrentAutoTable(), this);
        for (int i = 0; i < len; ++i) {
            if (!s.readBoolean()) continue;
            this._nbsi.add(i);
        }
    }

    private static final class NBSI {
        private final transient NonBlockingSetInt _non_blocking_set_int;
        private final transient ConcurrentAutoTable _size;
        private final long[] _bits;
        private static final int _Lbase = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
        private static final int _Lscale = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        private NBSI _new;
        private static final long _new_offset = UnsafeAccess.fieldOffset(NBSI.class, "_new");
        private final transient AtomicInteger _copyIdx;
        private final transient AtomicInteger _copyDone;
        private final transient int _sum_bits_length;
        private final NBSI _nbsi64;

        private static long rawIndex(long[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Lbase + idx * _Lscale;
        }

        private final boolean CAS(int idx, long old, long nnn) {
            return UnsafeAccess.UNSAFE.compareAndSwapLong(this._bits, NBSI.rawIndex(this._bits, idx), old, nnn);
        }

        private final boolean CAS_new(NBSI nnn) {
            return UnsafeAccess.UNSAFE.compareAndSwapObject(this, _new_offset, null, nnn);
        }

        private static final long mask(int i) {
            return 1L << (i & 0x3F);
        }

        private NBSI(int max_elem, ConcurrentAutoTable ctr, NonBlockingSetInt nonb) {
            this._non_blocking_set_int = nonb;
            this._size = ctr;
            this._copyIdx = ctr == null ? null : new AtomicInteger();
            this._copyDone = ctr == null ? null : new AtomicInteger();
            this._bits = new long[(int)((long)max_elem + 63L >>> 6)];
            this._nbsi64 = max_elem + 1 >>> 6 == 0 ? null : new NBSI(max_elem + 1 >>> 6, null, null);
            this._sum_bits_length = this._bits.length + (this._nbsi64 == null ? 0 : this._nbsi64._sum_bits_length);
        }

        public boolean add(int i) {
            long old;
            if (i >> 6 >= this._bits.length) {
                return this.install_larger_new_bits(i).help_copy().add(i);
            }
            NBSI nbsi = this;
            int j = i;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            do {
                if ((old = nbsi._bits[j >> 6]) < 0L) {
                    return this.help_copy_impl(i).help_copy().add(i);
                }
                if ((old & mask) == 0L) continue;
                return false;
            } while (!nbsi.CAS(j >> 6, old, old | mask));
            this._size.add(1L);
            return true;
        }

        public boolean remove(int i) {
            long old;
            if (i >> 6 >= this._bits.length) {
                return this._new != null && this.help_copy().remove(i);
            }
            NBSI nbsi = this;
            int j = i;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            do {
                if ((old = nbsi._bits[j >> 6]) < 0L) {
                    return this.help_copy_impl(i).help_copy().remove(i);
                }
                if ((old & mask) != 0L) continue;
                return false;
            } while (!nbsi.CAS(j >> 6, old, old & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
            this._size.add(-1L);
            return true;
        }

        public boolean contains(int i) {
            if (i >> 6 >= this._bits.length) {
                return this._new != null && this.help_copy().contains(i);
            }
            NBSI nbsi = this;
            int j = i;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            long old = nbsi._bits[j >> 6];
            if (old < 0L) {
                return this.help_copy_impl(i).help_copy().contains(i);
            }
            return (old & mask) != 0L;
        }

        public int size() {
            return (int)this._size.get();
        }

        private NBSI install_larger_new_bits(int i) {
            if (this._new == null) {
                int sz = this._bits.length << 6 << 1;
                this.CAS_new(new NBSI(sz, this._size, this._non_blocking_set_int));
            }
            return this;
        }

        private NBSI help_copy() {
            NBSI top_nbsi = this._non_blocking_set_int._nbsi;
            int HELP = 8;
            int idx = top_nbsi._copyIdx.getAndAdd(512);
            for (int i = 0; i < 8; ++i) {
                int j = idx + i * 64;
                top_nbsi.help_copy_impl(j %= top_nbsi._bits.length << 6);
                top_nbsi.help_copy_impl(j + 63);
            }
            if (top_nbsi._copyDone.get() != top_nbsi._sum_bits_length || this._non_blocking_set_int.CAS_nbsi(top_nbsi, top_nbsi._new)) {
                // empty if block
            }
            return this._new;
        }

        private NBSI help_copy_impl(int i) {
            NBSI old = this;
            NBSI nnn = this._new;
            if (nnn == null) {
                return this;
            }
            int j = i;
            while ((j & 0x3F) == 63) {
                old = old._nbsi64;
                nnn = nnn._nbsi64;
                j >>= 6;
            }
            long bits = old._bits[j >> 6];
            while (bits >= 0L) {
                long oldbits = bits;
                if (old.CAS(j >> 6, oldbits, bits |= NBSI.mask(63))) {
                    if (oldbits != 0L) break;
                    this._copyDone.addAndGet(1);
                    break;
                }
                bits = old._bits[j >> 6];
            }
            if (bits != NBSI.mask(63)) {
                long new_bits = nnn._bits[j >> 6];
                if (new_bits == 0L) {
                    new_bits = bits & (NBSI.mask(63) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (!nnn.CAS(j >> 6, 0L, new_bits)) {
                        new_bits = nnn._bits[j >> 6];
                    }
                    assert (new_bits != 0L);
                }
                if (old.CAS(j >> 6, bits, NBSI.mask(63))) {
                    this._copyDone.addAndGet(1);
                }
            }
            return this;
        }

        private void print(int d, String msg) {
            for (int i = 0; i < d; ++i) {
                System.out.print("  ");
            }
            System.out.println(msg);
        }

        private void print(int d) {
            StringBuilder buf = new StringBuilder();
            buf.append("NBSI - _bits.len=");
            NBSI x = this;
            while (x != null) {
                buf.append(" " + x._bits.length);
                x = x._nbsi64;
            }
            this.print(d, buf.toString());
            x = this;
            while (x != null) {
                for (int i = 0; i < x._bits.length; ++i) {
                    System.out.print(Long.toHexString(x._bits[i]) + " ");
                }
                x = x._nbsi64;
                System.out.println();
            }
            if (this._copyIdx.get() != 0 || this._copyDone.get() != 0) {
                this.print(d, "_copyIdx=" + this._copyIdx.get() + " _copyDone=" + this._copyDone.get() + " _words_to_cpy=" + this._sum_bits_length);
            }
            if (this._new != null) {
                this.print(d, "__has_new - ");
                this._new.print(d + 1);
            }
        }
    }

    private class iter
    implements Iterator<Integer> {
        NBSI _nbsi2;
        int _idx = -1;
        int _prev = -1;

        iter() {
            this._nbsi2 = NonBlockingSetInt.this._nbsi;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this._idx != -2;
        }

        private void advance() {
            do {
                ++this._idx;
                while (this._idx >> 6 >= this._nbsi2._bits.length) {
                    if (this._nbsi2._new == null) {
                        this._idx = -2;
                        return;
                    }
                    this._nbsi2 = this._nbsi2._new;
                }
            } while (!this._nbsi2.contains(this._idx));
        }

        @Override
        public Integer next() {
            if (this._idx == -1) {
                throw new NoSuchElementException();
            }
            this._prev = this._idx;
            this.advance();
            return this._prev;
        }

        @Override
        public void remove() {
            if (this._prev == -1) {
                throw new IllegalStateException();
            }
            this._nbsi2.remove(this._prev);
            this._prev = -1;
        }
    }
}

