/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.jctools.queues.atomic;

import co.elastic.apm.agent.shaded.jctools.queues.MessagePassingQueue;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.BaseLinkedAtomicQueue;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.LinkedQueueAtomicNode;

public final class MpscLinkedAtomicQueue<E>
extends BaseLinkedAtomicQueue<E> {
    public MpscLinkedAtomicQueue() {
        LinkedQueueAtomicNode node = this.newNode();
        this.spConsumerNode(node);
        this.xchgProducerNode(node);
    }

    @Override
    public final boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        LinkedQueueAtomicNode<E> nextNode = this.newNode(e);
        LinkedQueueAtomicNode<E> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    public final E poll() {
        LinkedQueueAtomicNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueAtomicNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        if (currConsumerNode != this.lvProducerNode()) {
            nextNode = this.spinWaitForNextNode(currConsumerNode);
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        return null;
    }

    @Override
    public final E peek() {
        LinkedQueueAtomicNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueAtomicNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        if (currConsumerNode != this.lvProducerNode()) {
            nextNode = this.spinWaitForNextNode(currConsumerNode);
            return nextNode.lpValue();
        }
        return null;
    }

    @Override
    public final boolean remove(Object o) {
        LinkedQueueAtomicNode originalConsumerNode;
        if (null == o) {
            return false;
        }
        LinkedQueueAtomicNode prevConsumerNode = originalConsumerNode = this.lpConsumerNode();
        LinkedQueueAtomicNode currConsumerNode = this.getNextConsumerNode(originalConsumerNode);
        while (currConsumerNode != null) {
            if (o.equals(currConsumerNode.lpValue())) {
                LinkedQueueAtomicNode nextNode = this.getNextConsumerNode(currConsumerNode);
                if (nextNode != null) {
                    prevConsumerNode.soNext(nextNode);
                } else {
                    prevConsumerNode.soNext(null);
                    if (!this.casProducerNode(currConsumerNode, prevConsumerNode)) {
                        nextNode = this.spinWaitForNextNode(currConsumerNode);
                        prevConsumerNode.soNext(nextNode);
                    }
                }
                currConsumerNode.soNext(null);
                currConsumerNode.spValue(null);
                return true;
            }
            prevConsumerNode = currConsumerNode;
            currConsumerNode = this.getNextConsumerNode(currConsumerNode);
        }
        return false;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        long result = 0L;
        do {
            this.fill(s, 4096);
        } while ((result += 4096L) <= 0x7FFFEFFFL);
        return (int)result;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        LinkedQueueAtomicNode<E> tail;
        if (limit == 0) {
            return 0;
        }
        LinkedQueueAtomicNode<E> head = tail = this.newNode(s.get());
        for (int i = 1; i < limit; ++i) {
            LinkedQueueAtomicNode<E> temp = this.newNode(s.get());
            tail.soNext(temp);
            tail = temp;
        }
        LinkedQueueAtomicNode<E> oldPNode = this.xchgProducerNode(tail);
        oldPNode.soNext(head);
        return limit;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            this.fill(s, 4096);
        }
    }

    private LinkedQueueAtomicNode<E> getNextConsumerNode(LinkedQueueAtomicNode<E> currConsumerNode) {
        LinkedQueueAtomicNode<E> nextNode = currConsumerNode.lvNext();
        if (nextNode == null && currConsumerNode != this.lvProducerNode()) {
            nextNode = this.spinWaitForNextNode(currConsumerNode);
        }
        return nextNode;
    }

    private LinkedQueueAtomicNode<E> spinWaitForNextNode(LinkedQueueAtomicNode<E> currNode) {
        LinkedQueueAtomicNode<E> nextNode;
        while ((nextNode = currNode.lvNext()) == null) {
        }
        return nextNode;
    }
}

