/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.lmax.disruptor.dsl;

import co.elastic.apm.agent.shaded.lmax.disruptor.EventHandler;
import co.elastic.apm.agent.shaded.lmax.disruptor.EventProcessor;
import co.elastic.apm.agent.shaded.lmax.disruptor.Sequence;
import co.elastic.apm.agent.shaded.lmax.disruptor.SequenceBarrier;
import co.elastic.apm.agent.shaded.lmax.disruptor.dsl.ConsumerInfo;
import java.util.concurrent.Executor;

class EventProcessorInfo<T>
implements ConsumerInfo {
    private final EventProcessor eventprocessor;
    private final EventHandler<? super T> handler;
    private final SequenceBarrier barrier;
    private boolean endOfChain = true;

    EventProcessorInfo(EventProcessor eventprocessor, EventHandler<? super T> handler, SequenceBarrier barrier) {
        this.eventprocessor = eventprocessor;
        this.handler = handler;
        this.barrier = barrier;
    }

    public EventProcessor getEventProcessor() {
        return this.eventprocessor;
    }

    @Override
    public Sequence[] getSequences() {
        return new Sequence[]{this.eventprocessor.getSequence()};
    }

    public EventHandler<? super T> getHandler() {
        return this.handler;
    }

    @Override
    public SequenceBarrier getBarrier() {
        return this.barrier;
    }

    @Override
    public boolean isEndOfChain() {
        return this.endOfChain;
    }

    @Override
    public void start(Executor executor) {
        executor.execute(this.eventprocessor);
    }

    @Override
    public void halt() {
        this.eventprocessor.halt();
    }

    @Override
    public void markAsUsedInBarrier() {
        this.endOfChain = false;
    }

    @Override
    public boolean isRunning() {
        return this.eventprocessor.isRunning();
    }
}

