/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class TimestampSerializer {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final char TIME_SEPARATOR = 'T';
    private static final char TIME_ZONE_SEPARATOR = 'Z';
    private static final char COLON = ':';
    private static final char DOT = '.';
    private static final char ZERO = '0';
    private volatile CachedDate cachedDate = new CachedDate(System.currentTimeMillis());

    TimestampSerializer() {
    }

    void serializeEpochTimestampAsIsoDateTime(StringBuilder builder, long epochTimestamp) {
        CachedDate cachedDateLocal = this.cachedDate;
        if (cachedDateLocal == null || !cachedDateLocal.isDateCached(epochTimestamp)) {
            this.cachedDate = cachedDateLocal = new CachedDate(epochTimestamp);
        }
        builder.append(cachedDateLocal.getCachedDateIso());
        builder.append('T');
        long remainder = epochTimestamp % 86400000L;
        this.serializeWithLeadingZero(builder, remainder / 3600000L, 2);
        builder.append(':');
        this.serializeWithLeadingZero(builder, (remainder %= 3600000L) / 60000L, 2);
        builder.append(':');
        this.serializeWithLeadingZero(builder, (remainder %= 60000L) / 1000L, 2);
        builder.append('.');
        this.serializeWithLeadingZero(builder, remainder %= 1000L, 3);
        builder.append('Z');
    }

    private void serializeWithLeadingZero(StringBuilder builder, long value, int minLength) {
        for (int i = minLength - 1; i > 0; --i) {
            if (!((double)value < Math.pow(10.0, i))) continue;
            builder.append('0');
        }
        builder.append(value);
    }

    private static class CachedDate {
        private final String cachedDateIso;
        private final long startOfCachedDate;
        private final long endOfCachedDate;

        private CachedDate(long epochTimestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedDateIso = dateFormat.format(new Date(epochTimestamp));
            this.startOfCachedDate = CachedDate.atStartOfDay(epochTimestamp);
            this.endOfCachedDate = CachedDate.atEndOfDay(epochTimestamp);
        }

        private static long atStartOfDay(long epochTimestamp) {
            return epochTimestamp - epochTimestamp % 86400000L;
        }

        private static long atEndOfDay(long epochTimestamp) {
            return CachedDate.atStartOfDay(epochTimestamp) + 86400000L - 1L;
        }

        private boolean isDateCached(long epochTimestamp) {
            return epochTimestamp >= this.startOfCachedDate && epochTimestamp <= this.endOfCachedDate;
        }

        public String getCachedDateIso() {
            return this.cachedDateIso;
        }
    }
}

