/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.stagemonitor.configuration.converter;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.AbstractValueConverter;

public class EnumValueConverter<T extends Enum<T>>
extends AbstractValueConverter<T> {
    private final Class<T> enumClass;

    public EnumValueConverter(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public T convert(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Cant convert 'null' to " + this.enumClass.getSimpleName());
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Enum.valueOf(this.enumClass, name.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    return Enum.valueOf(this.enumClass, name.toUpperCase().replace("-", "_"));
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    throw new IllegalArgumentException("Can't convert " + name + " to " + this.enumClass.getSimpleName());
                }
            }
        }
    }

    @Override
    public String toString(T value) {
        if (value == null) {
            return null;
        }
        return ((Enum)value).name();
    }
}

