/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.urlconnection;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;

public class SSLContextInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("javax.net.ssl.SSLContext").or(ElementMatchers.named("javax.net.SocketFactory")).or(ElementMatchers.named("javax.net.ssl.SSLSocketFactory"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getDefault").and(ElementMatchers.isPublic()).and(ElementMatchers.isStatic()).and(ElementMatchers.takesArguments(0));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("ssl-context");
    }

    @Advice.OnMethodEnter(suppress=Throwable.class, skipOn=Advice.OnNonDefaultValue.class)
    public static boolean skipExecutionIfAgentThread() {
        return Thread.currentThread().getName().startsWith("elastic-apm-");
    }
}

