/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class IOUtils {
    static final int BYTE_BUFFER_CAPACITY = 2048;
    private static final ThreadLocal<ByteBuffer> threadLocalByteBuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(2048);
        }
    };
    private static final ThreadLocal<CharsetDecoder> threadLocalCharsetDecoder = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return StandardCharsets.UTF_8.newDecoder();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readUtf8Stream(InputStream is, CharBuffer charBuffer) throws IOException {
        ByteBuffer buffer = threadLocalByteBuffer.get();
        CharsetDecoder charsetDecoder = threadLocalCharsetDecoder.get();
        try {
            byte[] bufferArray = buffer.array();
            int read = is.read(bufferArray);
            while (read != -1) {
                ((Buffer)buffer).limit(read);
                CoderResult coderResult = charsetDecoder.decode(buffer, charBuffer, true);
                ((Buffer)buffer).clear();
                if (coderResult.isError()) {
                    ((Buffer)charBuffer).clear();
                    boolean bl = false;
                    return bl;
                }
                if (coderResult.isOverflow()) break;
                read = is.read(bufferArray);
            }
            charsetDecoder.flush(charBuffer);
            boolean bl = true;
            return bl;
        }
        finally {
            ((Buffer)charBuffer).flip();
            ((Buffer)buffer).clear();
            charsetDecoder.reset();
            is.close();
        }
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, CharBuffer charBuffer) {
        return IOUtils.decodeUtf8Bytes(bytes, 0, bytes.length, charBuffer);
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, int offset, int length, CharBuffer charBuffer) {
        ByteBuffer buffer;
        if (2048 < length) {
            buffer = ByteBuffer.wrap(bytes, offset, length);
        } else {
            buffer = threadLocalByteBuffer.get();
            buffer.put(bytes, offset, length);
            ((Buffer)buffer).position(0);
            ((Buffer)buffer).limit(length);
        }
        return IOUtils.decode(charBuffer, buffer);
    }

    public static CoderResult decodeUtf8Byte(byte b, CharBuffer charBuffer) {
        ByteBuffer buffer = threadLocalByteBuffer.get();
        buffer.put(b);
        ((Buffer)buffer).position(0);
        ((Buffer)buffer).limit(1);
        return IOUtils.decode(charBuffer, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CoderResult decode(CharBuffer charBuffer, ByteBuffer buffer) {
        CharsetDecoder charsetDecoder = threadLocalCharsetDecoder.get();
        try {
            CoderResult coderResult = charsetDecoder.decode(buffer, charBuffer, true);
            charsetDecoder.flush(charBuffer);
            CoderResult coderResult2 = coderResult;
            return coderResult2;
        }
        finally {
            ((Buffer)buffer).clear();
            charsetDecoder.reset();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized File exportResourceToTemp(String resource, String tempFileNamePrefix, String tempFileNameExtension) {
        try (InputStream resourceStream = IOUtils.class.getResourceAsStream("/" + resource);){
            File tempFile;
            block24: {
                if (resourceStream == null) {
                    throw new IllegalStateException(resource + " not found");
                }
                String hash = IOUtils.md5Hash(IOUtils.class.getResourceAsStream("/" + resource));
                tempFile = new File(System.getProperty("java.io.tmpdir"), tempFileNamePrefix + "-" + hash + tempFileNameExtension);
                if (!tempFile.exists()) {
                    try (FileOutputStream out = new FileOutputStream(tempFile);){
                        FileChannel channel = out.getChannel();
                        try (FileLock ignored = channel.lock();){
                            if (tempFile.length() == 0L) {
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = resourceStream.read(buffer)) != -1) {
                                    out.write(buffer, 0, length);
                                }
                            }
                            break block24;
                        }
                    }
                }
                if (!IOUtils.md5Hash(new FileInputStream(tempFile)).equals(hash)) {
                    throw new IllegalStateException("Invalid MD5 checksum of " + tempFile + ". Please delete this file.");
                }
            }
            File file = tempFile;
            return file;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String md5Hash(InputStream resourceAsStream) throws IOException, NoSuchAlgorithmException {
        try (InputStream is = resourceAsStream;){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            DigestInputStream dis = new DigestInputStream(is, md);
            while (dis.read(buffer) != -1) {
            }
            String string = String.format("%032x", new BigInteger(1, md.digest()));
            return string;
        }
    }
}

