/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;

public final class VersionUtils {
    @Nullable
    private static final String AGENT_VERSION = VersionUtils.getVersionFromPomProperties(VersionUtils.class, "co.elastic.apm", "elastic-apm-agent");

    private VersionUtils() {
    }

    @Nullable
    public static String getAgentVersion() {
        return AGENT_VERSION;
    }

    @Nullable
    public static String getVersionFromPomProperties(Class clazz, String groupId, String artifactId) {
        String classpathLocation = "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        Properties pomProperties = VersionUtils.getFromClasspath(classpathLocation, clazz);
        if (pomProperties != null) {
            return pomProperties.getProperty("version");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Properties getFromClasspath(String classpathLocation, Class clazz) {
        Properties props = new Properties();
        try (InputStream resourceStream = clazz.getResourceAsStream(classpathLocation);){
            if (resourceStream == null) return null;
            props.load(resourceStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

