/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package co.elastic.apm.agent.sdk.weakmap;

import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentSet;

import static co.elastic.apm.agent.sdk.weakmap.NullCheck.isNullValue;

/**
 * {@link WeakConcurrentSet} implementation that prevents throwing {@link NullPointerException} and helps debugging if needed
 *
 * @param <V> value type
 */
public class NullSafeWeakConcurrentSet<V> extends WeakConcurrentSet<V> {

    public NullSafeWeakConcurrentSet(Cleaner cleaner) {
        super(cleaner);
    }

    @Override
    public boolean add(V value) {
        if (isNullValue(value)) {
            return false;
        }
        return super.add(value);
    }

    @Override
    public boolean contains(V value) {
        if (isNullValue(value)) {
            return false;
        }
        return super.contains(value);
    }

    @Override
    public boolean remove(V value) {
        if (isNullValue(value)) {
            return false;
        }
        return super.remove(value);
    }
}
