/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
/**
 * Public API for Log4j 2.
 *
 * <p>
 *     The main entry point into Log4j is the {@link co.elastic.apm.agent.shaded.apache.logging.log4j.LogManager} class which can be used to
 *     obtain {@link co.elastic.apm.agent.shaded.apache.logging.log4j.Logger} objects, the current
 *     {@link co.elastic.apm.agent.shaded.apache.logging.log4j.spi.LoggerContext}, a new {@code LoggerContext}, and the current
 *     {@link co.elastic.apm.agent.shaded.apache.logging.log4j.spi.LoggerContextFactory}.
 * </p>
 * <p>
 *     {@link co.elastic.apm.agent.shaded.apache.logging.log4j.Marker} objects can be obtained through the
 *     {@link co.elastic.apm.agent.shaded.apache.logging.log4j.MarkerManager}. The MDC (Mapped Diagnostic Context) can be
 *     used through the {@link co.elastic.apm.agent.shaded.apache.logging.log4j.ThreadContext} class.
 * </p>
 *
 * @see <a href="http://logging.apache.org/log4j/2.x/manual/api.html">Log4j 2 API manual</a>
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j;
