/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

public class ShadedClassLoader
extends URLClassLoader {
    public static final String SHADED_CLASS_EXTENSION = ".esclazz";
    private static final String CLASS_EXTENSION = ".class";
    private final String customPrefix;
    private final Manifest manifest;
    private final URL jarUrl;

    public ShadedClassLoader(File jar, ClassLoader parent, String customPrefix) throws IOException {
        super(new URL[]{jar.toURI().toURL()}, parent);
        this.customPrefix = customPrefix;
        this.jarUrl = jar.toURI().toURL();
        try (JarFile jarFile = new JarFile(jar, false);){
            this.manifest = jarFile.getManifest();
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.getClassBytes(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes);
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> defineClass(String name, byte[] classBytes) {
        block5: {
            String packageName = this.getPackageName(name);
            if (packageName != null && this.getPackage(packageName) == null) {
                try {
                    if (this.manifest != null) {
                        this.definePackage(name, this.manifest, this.jarUrl);
                    } else {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (this.getPackage(packageName) != null) break block5;
                    throw e;
                }
            }
        }
        return this.defineClass(name, classBytes, 0, classBytes.length, ShadedClassLoader.class.getProtectionDomain());
    }

    @Nullable
    public String getPackageName(String className) {
        int i = className.lastIndexOf(46);
        if (i != -1) {
            return className.substring(0, i);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getClassBytes(String name) throws ClassNotFoundException {
        try (InputStream is = this.getResourceAsStream(name.replace('.', '/') + CLASS_EXTENSION);){
            int n;
            if (is == null) return null;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((n = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, n);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(this.getShadedResourceName(name));
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(this.getShadedResourceName(name));
    }

    private String getShadedResourceName(String name) {
        if (name.endsWith(CLASS_EXTENSION)) {
            return this.customPrefix + name.substring(0, name.length() - CLASS_EXTENSION.length()) + SHADED_CLASS_EXTENSION;
        }
        return this.customPrefix + name;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

