/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.asynchttpclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;

public abstract class AbstractAsyncHttpClientInstrumentation
extends ElasticApmInstrumentation {
    public static final WeakConcurrentMap<AsyncHandler<?>, Span> handlerSpanMap = new WeakConcurrentMap.WithInlinedExpunction();

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "asynchttpclient");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.asynchttpclient.AsyncHandler"));
    }

    public static class AsyncHandlerOnStatusReceivedInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnStatusReceivedInstrumentation() {
            super(ElementMatchers.named("onStatusReceived").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.asynchttpclient.HttpResponseStatus"))));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler, @Advice.Argument(value=0) HttpResponseStatus status) {
            Span span = (Span)handlerSpanMap.get(asyncHandler);
            if (span != null) {
                span.getContext().getHttp().withStatusCode(status.getStatusCode());
            }
        }
    }

    public static class AsyncHandlerOnThrowableInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnThrowableInstrumentation() {
            super(ElementMatchers.named("onThrowable").and(ElementMatchers.takesArguments(Throwable.class)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler, @Advice.Argument(value=0) Throwable t) {
            Span span = (Span)handlerSpanMap.remove(asyncHandler);
            if (span != null) {
                ((Span)span.captureException(t)).end();
            }
        }
    }

    public static class AsyncHandlerOnCompletedInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnCompletedInstrumentation() {
            super(ElementMatchers.named("onCompleted").and(ElementMatchers.takesArguments(0)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler) {
            Span span = (Span)handlerSpanMap.remove(asyncHandler);
            if (span != null) {
                span.end();
            }
        }
    }

    public static abstract class AbstractAsyncHandlerInstrumentation
    extends AbstractAsyncHttpClientInstrumentation {
        private final ElementMatcher<? super MethodDescription> methodMatcher;

        protected AbstractAsyncHandlerInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.hasSuperType(ElementMatchers.named("org.asynchttpclient.AsyncHandler"));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return this.methodMatcher;
        }
    }

    public static class AsyncHttpClientInstrumentation
    extends AbstractAsyncHttpClientInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) AsyncHandler<?> asyncHandler, @Advice.Local(value="span") Span span) {
            if (tracer == null || tracer.getActive() == null) {
                return;
            }
            TraceContextHolder<?> parent = tracer.getActive();
            span = HttpClientHelper.startHttpClientSpan(parent, request.getMethod(), request.getUri().toUrl(), request.getUri().getHost());
            if (span != null) {
                span.activate();
                request.getHeaders().add("elastic-apm-traceparent", (Object)span.getTraceContext().getOutgoingTraceParentHeader().toString());
                handlerSpanMap.put(asyncHandler, span);
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onAfterExecute(@Advice.Local(value="span") @Nullable Span span, @Advice.Argument(value=1) AsyncHandler<?> asyncHandler, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                span.deactivate();
                if (t != null) {
                    handlerSpanMap.remove(asyncHandler);
                    ((Span)span.captureException(t)).end();
                }
            }
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("org.asynchttpclient.DefaultAsyncHttpClient");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("executeRequest").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.asynchttpclient.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.asynchttpclient.AsyncHandler")));
        }
    }
}

