/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.dynamic.ClassFileLocator;
import co.elastic.apm.agent.shaded.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import co.elastic.apm.agent.shaded.bytebuddy.dynamic.loading.ClassInjector;
import co.elastic.apm.agent.shaded.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

public abstract class HelperClassManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(HelperClassManager.class);
    protected final ElasticApmTracer tracer;
    protected final String implementation;
    protected final String[] additionalHelpers;

    protected HelperClassManager(ElasticApmTracer tracer, String implementation, String[] additionalHelpers) {
        this.tracer = tracer;
        this.implementation = implementation;
        this.additionalHelpers = additionalHelpers;
    }

    @Nullable
    public T getForClassLoaderOfClass(Class<?> classOfTargetClassLoader) {
        T ret = null;
        try {
            ret = this.doGetForClassLoaderOfClass(classOfTargetClassLoader);
        }
        catch (Throwable throwable) {
            logger.error("Failed to load Helper class " + this.implementation + " for class " + classOfTargetClassLoader + ", loaded by ClassLoader " + classOfTargetClassLoader.getClassLoader(), throwable);
        }
        return ret;
    }

    @Nullable
    protected abstract T doGetForClassLoaderOfClass(Class<?> var1) throws Exception;

    static Class injectClass(@Nullable ClassLoader targetClassLoader, @Nullable ProtectionDomain pd, String className, boolean isBootstrapClass) throws IOException, ClassNotFoundException {
        if (targetClassLoader == null) {
            if (isBootstrapClass) {
                return Class.forName(className, false, null);
            }
            throw new UnsupportedOperationException("Cannot load non-bootstrap class from bootstrap class loader");
        }
        ClassInjector classInjector = targetClassLoader == ClassLoader.getSystemClassLoader() ? ClassInjector.UsingReflection.ofSystemClassLoader() : new ClassInjector.UsingReflection(targetClassLoader, pd, PackageDefinitionStrategy.NoOp.INSTANCE, true);
        byte[] classBytes = HelperClassManager.getAgentClassBytes(className);
        TypeDescription.Latent typeDesc = new TypeDescription.Latent(className, 0, null, Collections.emptyList());
        HashMap<TypeDescription.Latent, byte[]> typeMap = new HashMap<TypeDescription.Latent, byte[]>();
        typeMap.put(typeDesc, classBytes);
        return classInjector.inject(typeMap).values().iterator().next();
    }

    private static <T> T createHelper(@Nullable ClassLoader targetClassLoader, ElasticApmTracer tracer, String implementation, String ... additionalHelpers) {
        try {
            Class<T> helperClass;
            Map<String, byte[]> typeDefinitions = HelperClassManager.getTypeDefinitions(HelperClassManager.asList(implementation, additionalHelpers));
            try {
                helperClass = HelperClassManager.loadHelperClass(targetClassLoader, implementation, typeDefinitions);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                helperClass = HelperClassManager.loadHelperClass(ClassLoader.getSystemClassLoader(), implementation, typeDefinitions);
            }
            try {
                return helperClass.getDeclaredConstructor(ElasticApmTracer.class).newInstance(tracer);
            }
            catch (NoSuchMethodException e) {
                return helperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> asList(String implementation, String[] additionalHelpers) {
        ArrayList<String> list = new ArrayList<String>(additionalHelpers.length + 1);
        list.add(implementation);
        list.addAll(Arrays.asList(additionalHelpers));
        return list;
    }

    private static <T> Class<T> loadHelperClass(@Nullable ClassLoader targetClassLoader, String implementation, Map<String, byte[]> typeDefinitions) throws ClassNotFoundException {
        ByteArrayClassLoader.ChildFirst helperCL = new ByteArrayClassLoader.ChildFirst(targetClassLoader, true, typeDefinitions);
        return helperCL.loadClass(implementation);
    }

    private static Map<String, byte[]> getTypeDefinitions(List<String> helperClassNames) throws IOException {
        HashMap<String, byte[]> typeDefinitions = new HashMap<String, byte[]>();
        for (String helperName : helperClassNames) {
            byte[] classBytes = HelperClassManager.getAgentClassBytes(helperName);
            typeDefinitions.put(helperName, classBytes);
        }
        return typeDefinitions;
    }

    private static byte[] getAgentClassBytes(String className) throws IOException {
        ClassFileLocator locator = ClassFileLocator.ForClassLoader.of(ClassLoader.getSystemClassLoader());
        return locator.locate(className).resolve();
    }

    public static class ForAnyClassLoader<T>
    extends HelperClassManager<T> {
        static final Map<ClassLoader, WeakReference<List<Object>>> clId2helperImplListMap = new WeakHashMap<ClassLoader, WeakReference<List<Object>>>();
        final WeakConcurrentMap<ClassLoader, WeakReference<T>> clId2helperMap = new WeakConcurrentMap(false);

        private ForAnyClassLoader(ElasticApmTracer tracer, String implementation, String ... additionalHelpers) {
            super(tracer, implementation, additionalHelpers);
        }

        public static <T> ForAnyClassLoader<T> of(ElasticApmTracer tracer, String implementation, String ... additionalHelpers) {
            return new ForAnyClassLoader<T>(tracer, implementation, additionalHelpers);
        }

        @Override
        @Nullable
        public T doGetForClassLoaderOfClass(Class<?> classOfTargetClassLoader) throws Exception {
            ClassLoader targetCl = classOfTargetClassLoader.getClassLoader();
            WeakReference<T> helperRef = this.clId2helperMap.get(targetCl);
            if (helperRef == null) {
                return this.loadAndReferenceHelper(classOfTargetClassLoader);
            }
            return helperRef.get();
        }

        @Nullable
        private synchronized T loadAndReferenceHelper(Class<?> classOfTargetClassLoader) throws Exception {
            Object helper;
            ClassLoader targetCl = classOfTargetClassLoader.getClassLoader();
            WeakReference<T> helperRef = this.clId2helperMap.get(targetCl);
            if (helperRef == null) {
                try {
                    this.clId2helperMap.expungeStaleEntries();
                    helper = HelperClassManager.createHelper(targetCl, this.tracer, this.implementation, this.additionalHelpers);
                    List helperImplList = null;
                    WeakReference<List<Object>> helperImplListRef = clId2helperImplListMap.get(targetCl);
                    if (helperImplListRef != null) {
                        helperImplList = (List)helperImplListRef.get();
                    }
                    if (helperImplList == null) {
                        Class helperHolderClass = ForAnyClassLoader.injectClass(targetCl, classOfTargetClassLoader.getProtectionDomain(), "co.elastic.apm.agent.bci.HelperHolder", true);
                        helperImplList = (List)helperHolderClass.getField("helperInstanceList").get(null);
                        clId2helperImplListMap.put(targetCl, new WeakReference<List>(helperImplList));
                    }
                    helperImplList.add(helper);
                    this.clId2helperMap.put(targetCl, new WeakReference(helper));
                }
                catch (Throwable throwable) {
                    this.clId2helperMap.putIfAbsent(targetCl, new WeakReference<Object>(null));
                    throw throwable;
                }
            } else {
                helper = helperRef.get();
            }
            return helper;
        }
    }

    public static class ForSingleClassLoader<T>
    extends HelperClassManager<T> {
        @Nullable
        private volatile T helperImplementation;
        private boolean failed;

        private ForSingleClassLoader(ElasticApmTracer tracer, String implementation, String ... additionalHelpers) {
            super(tracer, implementation, additionalHelpers);
        }

        public static <T> ForSingleClassLoader<T> of(ElasticApmTracer tracer, String implementation, String ... additionalHelpers) {
            return new ForSingleClassLoader<T>(tracer, implementation, additionalHelpers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T doGetForClassLoaderOfClass(Class<?> classOfTargetClassLoader) {
            if (this.failed) {
                return null;
            }
            Object localHelper = this.helperImplementation;
            if (localHelper == null) {
                ForSingleClassLoader forSingleClassLoader = this;
                synchronized (forSingleClassLoader) {
                    localHelper = this.helperImplementation;
                    if (localHelper == null) {
                        try {
                            localHelper = HelperClassManager.createHelper(classOfTargetClassLoader.getClassLoader(), this.tracer, this.implementation, this.additionalHelpers);
                        }
                        catch (Throwable throwable) {
                            this.failed = true;
                            throw throwable;
                        }
                        this.helperImplementation = localHelper;
                    }
                }
            }
            return localHelper;
        }
    }
}

