/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.annotation.AnnotationDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.ParameterDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nullable;

public class AnnotationValueOffsetMappingFactory
implements Advice.OffsetMapping.Factory<AnnotationValueExtractor> {
    @Override
    public Class<AnnotationValueExtractor> getAnnotationType() {
        return AnnotationValueExtractor.class;
    }

    @Override
    public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, final AnnotationDescription.Loadable<AnnotationValueExtractor> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
        return new Advice.OffsetMapping(){

            @Override
            public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
                return Advice.OffsetMapping.Target.ForStackManipulation.of(AnnotationValueOffsetMappingFactory.this.getAnnotationValue(instrumentedMethod, (AnnotationValueExtractor)annotation.loadSilent()));
            }
        };
    }

    @Nullable
    private Object getAnnotationValue(MethodDescription instrumentedMethod, AnnotationValueExtractor annotationValueExtractor) {
        for (TypeDescription typeDescription : instrumentedMethod.getDeclaredAnnotations().asTypeList()) {
            if (!ElementMatchers.named(annotationValueExtractor.annotationClassName()).matches(typeDescription)) continue;
            for (MethodDescription.InDefinedShape annotationMethod : typeDescription.getDeclaredMethods()) {
                if (!annotationMethod.getName().equals(annotationValueExtractor.method())) continue;
                return instrumentedMethod.getDeclaredAnnotations().ofType(typeDescription).getValue(annotationMethod).resolve();
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AnnotationValueExtractor {
        public String annotationClassName();

        public String method();
    }
}

