/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class MatcherTimer
implements Comparable<MatcherTimer> {
    private final String adviceClass;
    private final AtomicLong totalTypeMatchingDuration = new AtomicLong();
    private final AtomicLong totalMethodMatchingDuration = new AtomicLong();

    public MatcherTimer(String adviceClassName) {
        this.adviceClass = adviceClassName;
    }

    public void addTypeMatchingDuration(long typeMatchingDuration) {
        this.totalTypeMatchingDuration.addAndGet(typeMatchingDuration);
    }

    public void addMethodMatchingDuration(long methodMatchingDuration) {
        this.totalMethodMatchingDuration.addAndGet(methodMatchingDuration);
    }

    @Override
    public int compareTo(MatcherTimer o) {
        return Long.compare(o.getTotalTime(), this.getTotalTime());
    }

    public long getTotalTime() {
        return this.totalTypeMatchingDuration.get() + this.totalMethodMatchingDuration.get();
    }

    public static String getTableHeader() {
        return String.format("| %-40s | %-15s | %-15s |", "Advice name", "Type ns", "Method ns");
    }

    public String toString() {
        return String.format("| %-40s | %,15d | %,15d |", this.getSimpleClassName(this.adviceClass), this.totalTypeMatchingDuration.get(), this.totalMethodMatchingDuration.get());
    }

    @Nonnull
    private String getSimpleClassName(String className) {
        String simpleClassName = className.substring(this.adviceClass.lastIndexOf(36) + 1);
        return simpleClassName.substring(simpleClassName.lastIndexOf(46) + 1);
    }
}

