/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.methodmatching;

import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.shaded.stagemonitor.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class MethodMatcher {
    private static final String MODIFIER = "(public|private|protected|\\*)";
    private static final String CLASS_NAME = "([a-zA-Z\\d_$.\\*]+)";
    private static final String METHOD_NAME = "([a-zA-Z\\d_$\\*]+)";
    private static final String PARAM = "([a-zA-Z\\d_$.\\[\\]\\*]+)";
    private static final String PARAMS = "([a-zA-Z\\d_$.\\[\\]\\*]+)(,\\s*([a-zA-Z\\d_$.\\[\\]\\*]+))*";
    private static final Pattern METHOD_MATCHER_PATTERN = Pattern.compile("^((public|private|protected|\\*)\\s+)?([a-zA-Z\\d_$.\\*]+)(#([a-zA-Z\\d_$\\*]+)(\\((([a-zA-Z\\d_$.\\[\\]\\*]+)(,\\s*([a-zA-Z\\d_$.\\[\\]\\*]+))*)*\\))?)?$");
    private final String stringRepresentation;
    @Nullable
    private final Integer modifier;
    private final WildcardMatcher classMatcher;
    private final WildcardMatcher methodMatcher;
    @Nullable
    private final List<WildcardMatcher> argumentMatchers;

    private MethodMatcher(String stringRepresentation, @Nullable Integer modifier, WildcardMatcher classMatcher, WildcardMatcher methodMatcher, @Nullable List<WildcardMatcher> argumentMatchers) {
        this.stringRepresentation = stringRepresentation;
        this.modifier = modifier;
        this.classMatcher = classMatcher;
        this.methodMatcher = methodMatcher;
        this.argumentMatchers = argumentMatchers;
    }

    public static MethodMatcher of(String methodMatcher) {
        Matcher matcher = METHOD_MATCHER_PATTERN.matcher(methodMatcher);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("'" + methodMatcher + "' is not a valid method matcher");
        }
        String modifier = matcher.group(2);
        WildcardMatcher clazz = WildcardMatcher.caseSensitiveMatcher(matcher.group(3));
        WildcardMatcher method = matcher.group(5) != null ? WildcardMatcher.caseSensitiveMatcher(matcher.group(5)) : WildcardMatcher.matchAll();
        List<WildcardMatcher> args = MethodMatcher.getArgumentMatchers(matcher.group(6));
        return new MethodMatcher(methodMatcher, MethodMatcher.getModifier(modifier), clazz, method, args);
    }

    @Nullable
    private static Integer getModifier(@Nullable String modifier) {
        if (modifier == null) {
            return null;
        }
        switch (modifier) {
            case "public": {
                return 1;
            }
            case "private": {
                return 2;
            }
            case "protected": {
                return 4;
            }
        }
        return null;
    }

    @Nullable
    private static List<WildcardMatcher> getArgumentMatchers(@Nullable String arguments) {
        if (arguments == null) {
            return null;
        }
        arguments = arguments.substring(1, arguments.length() - 1);
        String[] splitArguments = StringUtils.split(arguments, ',');
        ArrayList<WildcardMatcher> matchers = new ArrayList<WildcardMatcher>(splitArguments.length);
        for (String argument : splitArguments) {
            matchers.add(WildcardMatcher.caseSensitiveMatcher(argument.trim()));
        }
        return matchers;
    }

    public WildcardMatcher getClassMatcher() {
        return this.classMatcher;
    }

    @Nullable
    public Integer getModifier() {
        return this.modifier;
    }

    public WildcardMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    @Nullable
    public List<WildcardMatcher> getArgumentMatchers() {
        return this.argumentMatchers;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

