/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.agent.util.VersionUtils;
import java.util.List;

public class StartupInfo
implements LifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(StartupInfo.class);
    private final String elasticApmVersion;

    public StartupInfo() {
        String version = VersionUtils.getVersionFromPomProperties(this.getClass(), "co.elastic.apm", "elastic-apm-agent");
        this.elasticApmVersion = version != null ? version : "(unknown version)";
    }

    private static String getJvmAndOsVersionString() {
        return "Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ") " + System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    @Override
    public void start(ElasticApmTracer tracer) {
        ConfigurationRegistry configurationRegistry = tracer.getConfigurationRegistry();
        this.logConfiguration(configurationRegistry, logger);
    }

    void logConfiguration(ConfigurationRegistry configurationRegistry, Logger logger) {
        String serviceName = configurationRegistry.getConfig(CoreConfiguration.class).getServiceName();
        logger.info("Starting Elastic APM {} as {} on {}", this.elasticApmVersion, serviceName, StartupInfo.getJvmAndOsVersionString());
        for (List<ConfigurationOption<?>> options : configurationRegistry.getConfigurationOptionsByCategory().values()) {
            for (ConfigurationOption<?> option : options) {
                if (option.isDefault()) continue;
                this.logConfigWithNonDefaultValue(logger, option);
            }
        }
        if (configurationRegistry.getConfig(StacktraceConfiguration.class).getApplicationPackages().isEmpty()) {
            logger.warn("To enable all features and to increase startup times, please configure {}", (Object)"application_packages");
        }
    }

    private void logConfigWithNonDefaultValue(Logger logger, ConfigurationOption<?> option) {
        logger.debug("{}: '{}' (source: {})", option.getKey(), option.isSensitive() ? "XXXX" : option.getValueAsSafeString(), option.getNameOfCurrentConfigurationSource());
        if (option.getTags().contains("deprecated")) {
            logger.warn("Detected usage of deprecated configuration option '{}'. This option might be removed in the future. Please refer to the documentation about alternatives.", (Object)option.getKey());
        }
        if (!option.getKey().equals(option.getUsedKey())) {
            logger.warn("Detected usage of an old configuration key: '{}'. Please use '{}' instead.", (Object)option.getUsedKey(), (Object)option.getKey());
        }
        if (option.getValue() instanceof TimeDuration && !TimeDuration.DURATION_PATTERN.matcher(option.getValueAsString()).matches()) {
            logger.warn("DEPRECATION WARNING: {}: '{}' (source: {}) is not using a time unit. Please use one of 'ms', 's' or 'm'.", option.getKey(), option.getValueAsString(), option.getNameOfCurrentConfigurationSource());
        }
    }

    @Override
    public void stop() throws Exception {
    }
}

