/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.http.client;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import java.net.URI;
import javax.annotation.Nullable;

public class HttpClientHelper {
    public static final String EXTERNAL_TYPE = "external";
    public static final String HTTP_SUBTYPE = "http";

    @Nullable
    public static Span startHttpClientSpan(TraceContextHolder<?> parent, String method, @Nullable URI uri, String hostName) {
        return HttpClientHelper.startHttpClientSpan(parent, method, uri != null ? uri.toString() : null, hostName);
    }

    @Nullable
    public static Span startHttpClientSpan(TraceContextHolder<?> parent, String method, @Nullable String uri, String hostName) {
        Span span = parent.createExitSpan();
        if (span != null) {
            ((Span)((Span)span.withType(EXTERNAL_TYPE).withSubtype(HTTP_SUBTYPE).appendToName(method)).appendToName(" ")).appendToName(hostName);
            if (uri != null) {
                span.getContext().getHttp().withUrl(uri);
            }
        }
        return span;
    }
}

