/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.configuration.AgentArgumentsConfigurationSource;
import co.elastic.apm.agent.configuration.ApmServerConfigurationSource;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.PrefixingConfigurationSourceWrapper;
import co.elastic.apm.agent.configuration.source.PropertyFileConfigurationSource;
import co.elastic.apm.agent.configuration.source.SystemPropertyConfigurationSource;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.MetaData;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReporterFactory;
import co.elastic.apm.agent.report.serialize.DslJsonSerializer;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.AbstractConfigurationSource;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.EnvironmentVariableConfigurationSource;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.SimpleSource;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ElasticApmTracerBuilder {
    private final Logger logger;
    @Nullable
    private ConfigurationRegistry configurationRegistry;
    @Nullable
    private Reporter reporter;
    private final List<LifecycleListener> lifecycleListeners = new ArrayList<LifecycleListener>();
    private Map<String, String> inlineConfig = new HashMap<String, String>();
    @Nullable
    private final String agentArguments;

    public ElasticApmTracerBuilder() {
        this(null);
    }

    public ElasticApmTracerBuilder(@Nullable String agentArguments) {
        this.agentArguments = agentArguments;
        List<ConfigurationSource> configSources = this.getConfigSources(this.agentArguments);
        LoggingConfiguration.init(configSources);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public ElasticApmTracerBuilder configurationRegistry(ConfigurationRegistry configurationRegistry) {
        this.configurationRegistry = configurationRegistry;
        return this;
    }

    public ElasticApmTracerBuilder reporter(Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public ElasticApmTracerBuilder lifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        this.lifecycleListeners.addAll(lifecycleListeners);
        return this;
    }

    public ElasticApmTracerBuilder withConfig(String key, String value) {
        this.inlineConfig.put(key, value);
        return this;
    }

    public ElasticApmTracer build() {
        boolean addApmServerConfigSource = false;
        if (this.configurationRegistry == null) {
            addApmServerConfigSource = true;
            List<ConfigurationSource> configSources = this.getConfigSources(this.agentArguments);
            this.configurationRegistry = this.getDefaultConfigurationRegistry(configSources);
        }
        ApmServerClient apmServerClient = new ApmServerClient(this.configurationRegistry.getConfig(ReporterConfiguration.class));
        DslJsonSerializer payloadSerializer = new DslJsonSerializer(this.configurationRegistry.getConfig(StacktraceConfiguration.class), apmServerClient);
        MetaData metaData = MetaData.create(this.configurationRegistry, null, null);
        ApmServerConfigurationSource configurationSource = null;
        if (addApmServerConfigSource) {
            configurationSource = new ApmServerConfigurationSource(payloadSerializer, metaData, apmServerClient);
            this.configurationRegistry.addConfigurationSource(configurationSource);
        }
        if (this.reporter == null) {
            this.reporter = new ReporterFactory().createReporter(this.configurationRegistry, apmServerClient, metaData);
        }
        if (this.lifecycleListeners.isEmpty()) {
            if (configurationSource != null) {
                this.lifecycleListeners.add(configurationSource);
            }
            this.lifecycleListeners.addAll(DependencyInjectingServiceLoader.load(LifecycleListener.class, new Object[0]));
        }
        return new ElasticApmTracer(this.configurationRegistry, this.reporter, this.lifecycleListeners);
    }

    private ConfigurationRegistry getDefaultConfigurationRegistry(List<ConfigurationSource> configSources) {
        try {
            ConfigurationRegistry configurationRegistry = ConfigurationRegistry.builder().configSources(configSources).optionProviders(DependencyInjectingServiceLoader.load(ConfigurationOptionProvider.class, new Object[0])).failOnMissingRequiredValues(true).build();
            configurationRegistry.scheduleReloadAtRate(30L, TimeUnit.SECONDS);
            return configurationRegistry;
        }
        catch (IllegalStateException e) {
            this.logger.warn(e.getMessage());
            return ConfigurationRegistry.builder().addConfigSource(new SimpleSource("Noop Configuration").add("active", "false").add("instrument", "false").add("service_name", "none").add("transaction_sample_rate", "0")).optionProviders(DependencyInjectingServiceLoader.load(ConfigurationOptionProvider.class, new Object[0])).build();
        }
    }

    private List<ConfigurationSource> getConfigSources(@Nullable String agentArguments) {
        ArrayList<ConfigurationSource> result = new ArrayList<ConfigurationSource>();
        if (agentArguments != null && !agentArguments.isEmpty()) {
            result.add(AgentArgumentsConfigurationSource.parse(agentArguments));
        }
        result.add(new PrefixingConfigurationSourceWrapper(new SystemPropertyConfigurationSource(), "elastic.apm."));
        result.add(new PrefixingConfigurationSourceWrapper(new EnvironmentVariableConfigurationSource(), "ELASTIC_APM_"));
        result.add(new AbstractConfigurationSource(){

            @Override
            public String getValue(String key) {
                return (String)ElasticApmTracerBuilder.this.inlineConfig.get(key);
            }

            @Override
            public String getName() {
                return "Inline configuration";
            }
        });
        String configFileLocation = CoreConfiguration.getConfigFileLocation(result);
        if (configFileLocation != null && PropertyFileConfigurationSource.isPresent(configFileLocation)) {
            result.add(new PropertyFileConfigurationSource(configFileLocation));
        }
        if (PropertyFileConfigurationSource.isPresent("elasticapm.properties")) {
            result.add(new PropertyFileConfigurationSource("elasticapm.properties"));
        }
        return result;
    }
}

