/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractContext
implements Recyclable {
    private final Map<String, Object> labels = new ConcurrentHashMap<String, Object>();

    public Iterator<? extends Map.Entry<String, ?>> getLabelIterator() {
        return this.labels.entrySet().iterator();
    }

    public void addLabel(String key, String value) {
        this.labels.put(key, value);
    }

    public void addLabel(String key, Number value) {
        this.labels.put(key, value);
    }

    public void addLabel(String key, boolean value) {
        this.labels.put(key, value);
    }

    public Object getLabel(String key) {
        return this.labels.get(key);
    }

    public void clearLabels() {
        this.labels.clear();
    }

    public boolean hasLabels() {
        return !this.labels.isEmpty();
    }

    @Override
    public void resetState() {
        this.labels.clear();
    }

    public boolean hasContent() {
        return !this.labels.isEmpty();
    }

    public void copyFrom(AbstractContext other) {
        this.labels.putAll(other.labels);
    }
}

