/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.payload;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SystemInfo {
    private static final Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private static final String CONTAINER_UID_REGEX = "^[0-9a-fA-F]{64}$";
    private static final String SHORTENED_UUID_PATTERN = "^[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4,}";
    private static final String POD_REGEX = "(?:^/kubepods/[^/]+/pod([^/]+)$)|(?:^/kubepods\\.slice/kubepods-[^/]+\\.slice/kubepods-[^/]+-pod([^/]+)\\.slice$)";
    private final String architecture;
    private final String hostname;
    private final String platform;
    @Nullable
    private Container container;
    @Nullable
    private Kubernetes kubernetes;

    public SystemInfo(String architecture, String hostname, String platform) {
        this(architecture, hostname, platform, null, null);
    }

    SystemInfo(String architecture, String hostname, String platform, @Nullable Container container, @Nullable Kubernetes kubernetes) {
        this.architecture = architecture;
        this.hostname = hostname;
        this.platform = platform;
        this.container = container;
        this.kubernetes = kubernetes;
    }

    public static SystemInfo create() {
        return new SystemInfo(System.getProperty("os.arch"), SystemInfo.getNameOfLocalHost(), System.getProperty("os.name")).findContainerDetails();
    }

    static String getNameOfLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return SystemInfo.getHostNameFromEnv();
        }
    }

    SystemInfo findContainerDetails() {
        String containerId;
        block7: {
            containerId = null;
            try {
                Path path = FileSystems.getDefault().getPath("/proc/self/cgroup", new String[0]);
                if (!path.toFile().exists()) break block7;
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                for (String line : lines) {
                    this.parseContainerId(line);
                    if (this.container == null) continue;
                    containerId = this.container.getId();
                    break;
                }
            }
            catch (Throwable e) {
                logger.warn("Failed to read/parse container ID from '/proc/self/cgroup'", e);
            }
        }
        try {
            String podUid = System.getenv("KUBERNETES_POD_UID");
            String podName = System.getenv("KUBERNETES_POD_NAME");
            String nodeName = System.getenv("KUBERNETES_NODE_NAME");
            String namespace = System.getenv("KUBERNETES_NAMESPACE");
            if (podUid != null || podName != null || nodeName != null || namespace != null) {
                if (this.kubernetes != null && this.kubernetes.getPod() != null) {
                    podUid = podUid != null ? podUid : this.kubernetes.getPod().getUid();
                    podName = podName != null ? podName : this.kubernetes.getPod().getName();
                }
                this.kubernetes = new Kubernetes(podName, nodeName, namespace, podUid);
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to read environment variables for Kubernetes Downward API discovery", e);
        }
        logger.debug("container ID is {}", (Object)containerId);
        return this;
    }

    SystemInfo parseContainerId(String line) {
        String cGroupPath;
        int indexOfLastSlash;
        String[] fields = line.split(":");
        if (fields.length == 3 && (indexOfLastSlash = (cGroupPath = fields[2]).lastIndexOf(47)) >= 0) {
            Pattern pattern;
            Matcher matcher;
            String dir;
            String idPart = cGroupPath.substring(indexOfLastSlash + 1);
            if (idPart.endsWith(".scope")) {
                idPart = idPart.substring(0, idPart.length() - ".scope".length()).substring(idPart.indexOf("-") + 1);
            }
            if ((dir = cGroupPath.substring(0, indexOfLastSlash)).length() > 0 && (matcher = (pattern = Pattern.compile(POD_REGEX)).matcher(dir)).find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String podUid = matcher.group(i);
                    if (podUid == null || podUid.isEmpty()) continue;
                    logger.debug("Found Kubernetes pod UID: {}", (Object)podUid);
                    this.kubernetes = new Kubernetes(this.hostname, null, null, podUid);
                    break;
                }
            }
            if (this.kubernetes != null || idPart.matches(CONTAINER_UID_REGEX) || idPart.matches(SHORTENED_UUID_PATTERN)) {
                this.container = new Container(idPart);
            }
        }
        if (this.container == null) {
            logger.debug("Could not parse container ID from '/proc/self/cgroup' line: {}", (Object)line);
        }
        return this;
    }

    private static String getHostNameFromEnv() {
        String host = System.getenv("COMPUTERNAME");
        if (host == null) {
            host = System.getenv("HOSTNAME");
        }
        if (host == null) {
            host = System.getenv("HOST");
        }
        return host;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPlatform() {
        return this.platform;
    }

    @Nullable
    public Container getContainerInfo() {
        return this.container;
    }

    @Nullable
    public Kubernetes getKubernetesInfo() {
        return this.kubernetes;
    }

    public static class Kubernetes {
        @Nullable
        Pod pod;
        @Nullable
        Node node;
        @Nullable
        private String namespace;

        Kubernetes(@Nullable String podName, @Nullable String nodeName, @Nullable String namespace, @Nullable String podUid) {
            if (podName != null || podUid != null) {
                this.pod = new Pod(podName, podUid);
            }
            if (nodeName != null) {
                this.node = new Node(nodeName);
            }
            this.namespace = namespace;
        }

        @Nullable
        public Pod getPod() {
            return this.pod;
        }

        @Nullable
        public Node getNode() {
            return this.node;
        }

        @Nullable
        public String getNamespace() {
            return this.namespace;
        }

        public boolean hasContent() {
            return this.pod != null || this.node != null || this.namespace != null;
        }

        public static class Node {
            private String name;

            Node(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }

        public static class Pod {
            @Nullable
            private String name;
            @Nullable
            private String uid;

            Pod(@Nullable String name, @Nullable String uid) {
                this.name = name;
                this.uid = uid;
            }

            @Nullable
            public String getName() {
                return this.name;
            }

            @Nullable
            public String getUid() {
                return this.uid;
            }
        }
    }

    public static class Container {
        private String id;

        Container(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

