/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.stacktrace;

import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import java.util.Collection;
import java.util.Collections;

public class StacktraceConfiguration
extends ConfigurationOptionProvider {
    private static final String STACKTRACE_CATEGORY = "Stacktrace";
    public static final String APPLICATION_PACKAGES = "application_packages";
    private final ConfigurationOption<Collection<String>> applicationPackages = ConfigurationOption.stringsOption().key("application_packages").configurationCategory("Stacktrace").description("Used to determine whether a stack trace frame is an 'in-app frame' or a 'library frame'.\nMultiple packages can be set as a comma-separated list.\nSetting this option can also improve the startup time.\n\nIn order to be able to use the API annotations @CaptureTransaction and @CaptureSpan,\nit is required to set these options.").dynamic(true).buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<Integer> stackTraceLimit = ConfigurationOption.integerOption().key("stack_trace_limit").tags("performance").configurationCategory("Stacktrace").description("Setting it to 0 will disable stack trace collection. Any positive integer value will be used as the maximum number of frames to collect. Setting it -1 means that all frames will be collected.").dynamic(true).buildWithDefault(50);
    private final ConfigurationOption<TimeDuration> spanFramesMinDurationMs = TimeDurationValueConverter.durationOption("ms").key("span_frames_min_duration").aliasKeys("span_frames_min_duration_ms").tags("performance").configurationCategory("Stacktrace").description("In its default settings, the APM agent will collect a stack trace with every recorded span.\nWhile this is very helpful to find the exact place in your code that causes the span, collecting this stack trace does have some overhead. \nWhen setting this option to a negative value, like `-1ms`, stack traces will be collected for all spans. Setting it to a positive value, e.g. `5ms`, will limit stack trace collection to spans with durations equal to or longer than the given value, e.g. 5 milliseconds.\n\nTo disable stack trace collection for spans completely, set the value to `0ms`.").dynamic(true).buildWithDefault(TimeDuration.of("5ms"));

    public Collection<String> getApplicationPackages() {
        return this.applicationPackages.get();
    }

    public int getStackTraceLimit() {
        return this.stackTraceLimit.get();
    }

    public long getSpanFramesMinDurationMs() {
        return this.spanFramesMinDurationMs.getValue().getMillis();
    }
}

