/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.objectpool.impl.Resetter;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.MpmcAtomicArrayQueue;
import java.nio.Buffer;
import java.nio.CharBuffer;
import javax.annotation.Nullable;

public class Db
implements Recyclable {
    private static final ObjectPool<CharBuffer> charBufferPool = QueueBasedObjectPool.of(new MpmcAtomicArrayQueue(128), false, new Allocator<CharBuffer>(){

        @Override
        public CharBuffer createInstance() {
            return CharBuffer.allocate(10000);
        }
    }, new Resetter<CharBuffer>(){

        @Override
        public void recycle(CharBuffer object) {
            ((Buffer)object).clear();
        }
    });
    @Nullable
    private String instance;
    @Nullable
    private String statement;
    @Nullable
    private CharBuffer statementBuffer;
    @Nullable
    private String type;
    @Nullable
    private String user;
    @Nullable
    private String dbLink;

    @Nullable
    public String getInstance() {
        return this.instance;
    }

    public Db withInstance(@Nullable String instance) {
        this.instance = instance;
        return this;
    }

    @Nullable
    public String getStatement() {
        return this.statement;
    }

    public Db withStatement(@Nullable String statement) {
        this.statement = statement;
        return this;
    }

    public CharBuffer withStatementBuffer() {
        if (this.statementBuffer == null) {
            this.statementBuffer = charBufferPool.createInstance();
        }
        return this.statementBuffer;
    }

    @Nullable
    public CharBuffer getStatementBuffer() {
        return this.statementBuffer;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public Db withType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public Db withUser(@Nullable String user) {
        this.user = user;
        return this;
    }

    @Nullable
    public String getDbLink() {
        return this.dbLink;
    }

    public Db withDbLink(@Nullable String dbLink) {
        this.dbLink = dbLink;
        return this;
    }

    @Override
    public void resetState() {
        this.instance = null;
        this.statement = null;
        this.type = null;
        this.user = null;
        this.dbLink = null;
        if (this.statementBuffer != null) {
            charBufferPool.recycle(this.statementBuffer);
        }
        this.statementBuffer = null;
    }

    public boolean hasContent() {
        return this.instance != null || this.statement != null || this.type != null || this.user != null || this.dbLink != null || this.statementBuffer != null;
    }

    public void copyFrom(Db other) {
        this.instance = other.instance;
        this.statement = other.statement;
        this.type = other.type;
        this.user = other.user;
        this.dbLink = other.dbLink;
    }
}

