/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.objectpool.Recyclable;

public class EpochTickClock
implements Recyclable {
    private long nanoTimeOffsetToEpoch;

    public void init(EpochTickClock other) {
        this.nanoTimeOffsetToEpoch = other.nanoTimeOffsetToEpoch;
    }

    public long init() {
        return this.init(System.currentTimeMillis() * 1000L, System.nanoTime());
    }

    void init(long nanoTimeOffsetToEpoch) {
        this.nanoTimeOffsetToEpoch = nanoTimeOffsetToEpoch;
    }

    public long init(long epochMicrosWallClock, long nanoTime) {
        this.nanoTimeOffsetToEpoch = epochMicrosWallClock * 1000L - nanoTime;
        return epochMicrosWallClock;
    }

    public long getEpochMicros() {
        return this.getEpochMicros(System.nanoTime());
    }

    public long getEpochMicros(long nanoTime) {
        return (nanoTime + this.nanoTimeOffsetToEpoch) / 1000L;
    }

    @Override
    public void resetState() {
        this.nanoTimeOffsetToEpoch = 0L;
    }

    long getOffset() {
        return this.nanoTimeOffsetToEpoch;
    }
}

