/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public class Http
implements Recyclable {
    @Nullable
    private String url;
    @Nullable
    private String method;
    private int statusCode;

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Http withUrl(@Nullable String url) {
        if (url != null) {
            this.url = Http.sanitize(url);
        }
        return this;
    }

    @Nullable
    private static String sanitize(String uriString) {
        if (uriString.indexOf(64) < 0) {
            return uriString;
        }
        try {
            URI uri = new URI(uriString);
            if (uri.getUserInfo() != null) {
                return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
            }
            return uri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Http withMethod(String method) {
        this.method = method;
        return this;
    }

    public Http withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public void resetState() {
        this.url = null;
        this.method = null;
        this.statusCode = 0;
    }

    public boolean hasContent() {
        return this.url != null || this.method != null || this.statusCode > 0;
    }

    public void copyFrom(Http other) {
        this.url = other.url;
        this.method = other.method;
        this.statusCode = other.statusCode;
    }
}

